\name{h2example}
\alias{h2example}
\docType{data}
\title{
Broad sense heritability calculation.
}
\description{
This dataset contains phenotpic data for 41 potato lines evaluated in 5 locations across 3 years in an RCBD design. The phenotypic trait is tuber quality and we show how to obtain an estimate of h2example for the trait.

}
\usage{data("h2example")}
\format{
  The format is:
 chr "h2example"
}
\source{
This data was generated by a potato study.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{
####=========================================####
#### For CRAN time limitations most lines in the 
#### examples are silenced with one '#' mark, 
#### remove them and run the examples
####=========================================####
data(h2example)
head(h2example)
####=========================================####
#### fit the mixed model (very heavy model)
####=========================================####
# ans1 <- mmer2(y~Env,
#               random=~at(Env):Name + at(Env):Block,
#               rcov=~at(Env):units,
#               data=h2example)
# summary(ans1)

####=========================================####
#### calculate heritability
####=========================================####
# length(levels(h2example$Env)) # number of environment
# 2 # number of blocks
# # using the pin function
# pin(ans1,h2example~(V1+(V3/15))/(V1+(V3/15)+(V5/(2*15))))
# # using the 
# h2.fun(ans1, h2example, gTerm = "Name", eTerm = "Env")

####=========================================####
####=========================================####
#### using the 'mmer' function would be fitted as
####=========================================####
####=========================================####
#data(h2example)
#Y <- h2example$y
#Z1 <- model.matrix(~Name-1,data=h2example)
#Z2 <- model.matrix(~Env-1,data=h2example)
#Z3 <- model.matrix(~Name:Env-1,data=h2example)
#Z4 <- model.matrix(~Block-1,data=h2example)
#ETA <- list(Name=list(Z=Z1),
#            Env=list(Z=Z2),
#            Name.Env=list(Z=Z3),
#            Block=list(Z=Z4))

#ans1 <- mmer(Y=Y,Z=ETA)
#vc <- ans1$var.comp

}
\keyword{datasets}
\seealso{The core functions of the package \code{\link{mmer}} and \code{\link{mmer2}}}
