% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/solr_all.r
\name{solr_all}
\alias{solr_all}
\title{Solr search.}
\usage{
solr_all(q = "*:*", sort = NULL, start = 0, rows = NULL,
  pageDoc = NULL, pageScore = NULL, fq = NULL, fl = NULL,
  defType = NULL, timeAllowed = NULL, qt = NULL, wt = "json",
  NOW = NULL, TZ = NULL, echoHandler = NULL, echoParams = NULL,
  key = NULL, base = NULL, callopts = list(), raw = FALSE,
  parsetype = "df", concat = ",", ..., verbose = TRUE)
}
\arguments{
\item{q}{Query terms, defaults to '*:*', or everything.}

\item{sort}{Field to sort on. You can specify ascending (e.g., score desc) or
descending (e.g., score asc), sort by two fields (e.g., score desc, price asc),
or sort by a function (e.g., sum(x_f, y_f) desc, which sorts by the sum of
x_f and y_f in a descending order).}

\item{start}{Record to start at, default to beginning.}

\item{rows}{Number of records to return. Defaults to 10.}

\item{pageDoc}{If you expect to be paging deeply into the results (say beyond page 10,
assuming rows=10) and you are sorting by score, you may wish to add the pageDoc
and pageScore parameters to your request. These two parameters tell Solr (and Lucene)
what the last result (Lucene internal docid and score) of the previous page was,
so that when scoring the query for the next set of pages, it can ignore any results
that occur higher than that item. To get the Lucene internal doc id, you will need
to add [docid] to the &fl list.
e.g., q=*:*&start=10&pageDoc=5&pageScore=1.345&fl=[docid],score}

\item{pageScore}{See pageDoc notes.}

\item{fq}{Filter query, this does not affect the search, only what gets returned}

\item{fl}{Fields to return}

\item{defType}{Specify the query parser to use with this request.}

\item{timeAllowed}{The time allowed for a search to finish. This value only applies
to the search and not to requests in general. Time is in milliseconds. Values <= 0
mean no time restriction. Partial results may be returned (if there are any).}

\item{qt}{Which query handler used.}

\item{wt}{Data type returned, defaults to 'json'}

\item{NOW}{Set a fixed time for evaluating Date based expresions}

\item{TZ}{Time zone, you can override the default.}

\item{echoHandler}{If the echoHandler parameter is true, Solr places the name of
the handle used in the response to the client for debugging purposes.}

\item{echoParams}{The echoParams parameter tells Solr what kinds of Request
parameters should be included in the response for debugging purposes, legal values
include:
\itemize{
 \item none - don't include any request parameters for debugging
 \item explicit - include the parameters explicitly specified by the client in the request
 \item all - include all parameters involved in this request, either specified explicitly
 by the client, or implicit because of the request handler configuration.
}}

\item{key}{API key, if needed.}

\item{base}{URL endpoint.}

\item{callopts}{Call options passed on to httr::GET}

\item{raw}{(logical) If TRUE, returns raw data in format specified by wt param}

\item{parsetype}{(character) One of 'list' or 'df'}

\item{concat}{(character) Character to concatenate elements of longer than length 1.
Note that this only works reliably when data format is json (wt='json'). The parsing
is more complicated in XML format, but you can do that on your own.}

\item{...}{Further args.}

\item{verbose}{If TRUE (default) the url call used printed to console.}
}
\value{
XML, JSON, a list, or data.frame
}
\description{
Solr search.
}
\examples{
\dontrun{
url <- 'http://api.plos.org/search'
solr_all(q='*:*', rows=2, fl='id', base=url)
}
}
\references{
See \url{http://wiki.apache.org/solr/#Search_and_Indexing} for
more information.
}
\seealso{
\code{\link{solr_highlight}}, \code{\link{solr_facet}}
}

