% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateColorMixture.R
\name{estimateColorMixture}
\alias{estimateColorMixture}
\title{Estimate color mixtures using weighted average of CIELAB color coordinates}
\usage{
estimateColorMixture(x, wt = "pct", backTransform = FALSE)
}
\arguments{
\item{x}{data.frame, typically from NASIS containing at least CIE LAB ('L', 'A', 'B') and some kind of weight}

\item{wt}{fractional weights, usually area of hz face}

\item{backTransform}{logical, should the mixed sRGB representation of soil color be transformed to closest Munsell chips? This is performed by \code{\link[aqp:rgb2munsell]{aqp::rgb2munsell()}} default: \code{FALSE}}
}
\value{
A data.frame containing estimated color mixture
}
\description{
Estimate color mixtures using weighted average of CIELAB color coordinates
}
\note{
See \code{\link[aqp:mixMunsell]{aqp::mixMunsell()}} for a more realistic (but slower) simulation of subtractive mixing of pigments.
}
\author{
D.E. Beaudette
}
