% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/nsamples.R
\name{nsamples}
\alias{nsamples}
\title{Number of samples}
\usage{
nsamples(r = r, groups = NULL, operator = "prd", hard.operator)
}
\arguments{
\item{r}{reference class labels with samples in rows.}

\item{groups}{grouping variable for the averaging by \code{\link[base]{rowsum}}. If \code{NULL},
all samples (rows) are averaged.}

\item{operator}{the \code{\link[softclassval:operators]{operator}} to be used}

\item{hard.operator}{optional: a logical determining whether only hard samples should be counted}
}
\value{
number of samples in each group (rows) for each class (columns) and all further
dimensions of ref.
}
\description{
Count number of samples
}
\details{
Basically, the reference is summed up. For hard operators, the reference is hardened first: soft
values, i.e. \code{r} in (0, 1) are set to NA.
}
\examples{
ref <- softclassval:::ref
ref
nsamples (ref)
nsamples (ref, hard.operator = TRUE)
}
\author{
Claudia Beleites
}

