% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods_Incomplete.R
\docType{class}
\name{Incomplete-class}
\alias{Incomplete-class}
\alias{as.matrix,Incomplete-method}
\alias{coerce,matrix,Incomplete-method}
\alias{coerce,sparseMatrix,Incomplete-method}
\title{Class \code{"Incomplete"}}
\description{
a sparse matrix inheriting from class \code{dgCMatrix} with the NAs
represented as zeros
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("Incomplete", ...)} or by calling the function \code{Incomplete}
}

\section{Slots}{

\describe{
\item{i}{Object of class \code{"integer"}}
\item{p}{Object of class \code{"integer"}}
\item{Dim}{Object of class \code{"integer"}}
\item{Dimnames}{Object of class \code{"list"}}
\item{x}{Object of class \code{"numeric"}}
\item{factors}{Object of class \code{"list"}}
}
}

\section{Methods}{

\describe{
\item{as.matrix}{\code{signature(x = "Incomplete")}: ... }
\item{coerce}{\code{signature(from = "matrix", to = "Incomplete")}: ... }
\item{complete}{\code{signature(x = "Incomplete")}:... }
}
}

\examples{

showClass("Incomplete")
set.seed(101)
n=200
p=100
J=50
np=n*p
missfrac=0.3
x=matrix(rnorm(n*J),n,J)\%*\%matrix(rnorm(J*p),J,p)+matrix(rnorm(np),n,p)/5
ix=seq(np)
imiss=sample(ix,np*missfrac,replace=FALSE)
xna=x
xna[imiss]=NA
xnaC=as(xna,"Incomplete")
}
\seealso{
\code{biScale},\code{softImpute},\code{Incomplete},\code{impute},\code{complete}
}
\author{
Trevor Hastie and Rahul Mazumder
}
\keyword{classes}
