% Generated by roxygen2 (4.0.1): do not edit by hand
\name{run_parallel_SA}
\alias{run_parallel_SA}
\title{run_parallel_SA}
\usage{
run_parallel_SA(insms)
}
\arguments{
\item{insms}{A microsimulation object which holds the data and details
of the simulation such as iterations, lexicon.}
}
\value{
msm_results An object with the results of the simulation, for each area.
}
\description{
Run a simulation in parallel mode with Simulated Annealing
}
\examples{
library(sms)
data(survey)
data(census)
in.lexicon=createLexicon()
in.lexicon=addDataAssociation(in.lexicon, c("he","he"))
in.lexicon=addDataAssociation(in.lexicon, c("females","female"))

insms= new("microsimulation",census=census, panel=survey, lexicon=in.lexicon, iterations=5)
results= run_parallel_SA(insms)
print(results)
}
\author{
Dimitris Kavroudakis \email{dimitris123@gmail.com}
}

