\name{sample_generator}
\alias{sample_generator}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
	The function to generate 2-dimensional dataset
}
\description{
	The function to generate 2-dimensional dataset given the number of instances and the ratio between the number of negative instances to total instances. The positive instances will be distributed uniformly as the circle in the center while negative instances are around over the domain. The random positive outcasts are also generated. The dataset is used to show the difference between datasets generated by each sampling technique.
}
\usage{
sample_generator(n, ratio = 0.8, xlim = c(0, 1), ylim = c(0, 1),
   radius = 0.25, overlap = -0.05, outcast_ratio = 0.01)
}

\arguments{
  \item{n}{
	The number of instances in the dataset
}
  \item{ratio}{
	The ratio of negative instances to the total number of instances
}
  \item{xlim}{
	The range of values in the first dimension
}
  \item{ylim}{
	The range of values in the second dimension
}
  \item{radius}{
	The radius of the circle of positive instances
}
  \item{overlap}{
	The gap between the set of positive and negative instances
}
  \item{outcast_ratio}{
	The ratio of outcast to be generate in this dataset.
}
}

\value{
	A 2-dimensional dataset with the 3rd column as its target class vector. 
}

\author{
	Wacharasak Siriseriwan <wacharasak.s@gmail.com>
}
\examples{
	data_example = sample_generator(5000,ratio = 0.80)
	plot(data_example[data_example[,3]=="n",1],
	data_example[data_example[,3]=="n",2],col="yellow")
	points(data_example[data_example[,3]=="p",1],
	data_example[data_example[,3]=="p",2],col="red",pch=14)
}
