% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_cglasso.R
\name{plot.cv.cglasso}
\alias{plot.cv.cglasso}
\title{plot method for objects of \code{cv.cglasso} class}
\usage{
\method{plot}{cv.cglasso}(x, ...)
}
\arguments{
\item{x}{An fitted object in "cv.cglasso" class.}

\item{...}{Other graphical parameters to ggplot2.}
}
\description{
Yields a cross-validation curve, and error bars within one standard deviation of the curve,
as a function of the group penalty \eqn{\lambda_1}.
}
\examples{

# generate design matrix x
set.seed(2018)
n=50;p=20
s=10
x=matrix(0,n,1+2*p)
x[,1]=sample(c(0,1),n,replace = TRUE)
x[,seq(2,1+2*p,2)]=matrix(rnorm(n*p),n,p)
x[,seq(3,1+2*p,2)]=x[,seq(2,1+2*p,2)]*x[,1]

g=c(p+1,rep(1:p,rep(2,p)))  # groups 
v=c(0,rep(1,2*p))           # penalization status
label=c("t",rep(c("prog","pred"),p))  # type of predictor variables

# generate beta
beta=c(rnorm(13,0,2),rep(0,ncol(x)-13))
beta[c(2,4,7,9)]=0

# generate y
data=x\%*\%beta
noise=rnorm(n)
snr=as.numeric(sqrt(var(data)/(s*var(noise))))
y=data+snr*noise

cvfit=cv.cglasso(x,y,g,v,label,family="gaussian", nlambda.max = 20)
plot(cvfit)

}
\references{
\insertRef{ma2019structural}{smog}
}
\seealso{
\link{cv.cglasso}, \link{cv.smog}, \link{smog}.
}
\author{
Chong Ma, \email{chongma8903@gmail.com}.
}
