% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allgenerics.R
\name{getKernel}
\alias{getKernel}
\title{Method to get the semi-Markov kernel \eqn{q}}
\usage{
getKernel(x, k, var = FALSE, klim = 10000)
}
\arguments{
\item{x}{An object of S3 class \code{smmfit} or \code{smm}.}

\item{k}{A positive integer giving the time horizon.}

\item{var}{Logical. If \code{TRUE} the asymptotic variance is computed.}

\item{klim}{Optional. The time horizon used to approximate the series in the
computation of the mean sojourn times vector \eqn{m} (cf.
\link{meanSojournTimes} function) for the asymptotic variance.}
}
\value{
An array giving the value of \eqn{q_{ij}(k)} at each time between 0
and \code{k} if \code{var = FALSE}. If \code{var = TRUE}, a list containing the
following components:
\itemize{
\item{x: }{an array giving the value of \eqn{q_{ij}(k)} at each time
between 0 and \code{k};}
\item{sigma2: }{an array giving the asymptotic variance of the estimator
\eqn{\sigma_{q}^{2}(i, j, k)}.}
}
}
\description{
Computes the semi-Markov kernel \eqn{q_{ij}(k)}.
}
