% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allgenerics.R
\name{meanSojournTimes}
\alias{meanSojournTimes}
\title{Mean Sojourn Times Function}
\usage{
meanSojournTimes(x, states = x$states, klim = 10000)
}
\arguments{
\item{x}{An object of S3 class \code{smmfit} or \code{smm}.}

\item{states}{Vector giving the states for which the mean sojourn time
should be computed. \code{states} is a subset of \eqn{E}.}

\item{klim}{Optional. The time horizon used to approximate the series in the
computation of the mean sojourn times vector \eqn{m} (cf.
\link{meanSojournTimes} function).}
}
\value{
A vector of length \eqn{\textrm{card}(E)} giving the values of the
mean sojourn times for each state \eqn{i \in E}.
}
\description{
The mean sojourn time is the mean time spent in each state.
}
\details{
Consider a system (or a component) \eqn{S_{ystem}} whose possible
states during its evolution in time are \eqn{E = \{1,\dots,s\}}.

We are interested in investigating the mean sojourn times of a
discrete-time semi-Markov system \eqn{S_{ystem}}. Consequently, we suppose
that the evolution in time of the system is governed by an E-state space
semi-Markov chain \eqn{(Z_k)_{k \in N}}. The state of the system is given
at each instant \eqn{k \in N} by \eqn{Z_k}: the event \eqn{\{Z_k = i\}}.

Let \eqn{T = (T_{n})_{n \in N}} denote the successive time points when
state changes in \eqn{(Z_{n})_{n \in N}} occur and let also
\eqn{J = (J_{n})_{n \in N}} denote the successively visited states at
these time points.

The mean sojourn times vector is defined as follows:

\deqn{m_{i} = E[T_{1} | Z_{0} = j] = \sum_{k \geq 0} (1 - P(T_{n + 1} - T_{n} \leq k | J_{n} = j)) = \sum_{k \geq 0} (1 - H_{j}(k)),\ i \in E}
}
