% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnpop.R
\name{nnpop}
\alias{nnpop}
\alias{scan.nn}
\title{Determine nearest neighbors with population constraint}
\usage{
nnpop(d, pop, ubpop)

scan.nn(d, pop, ubpop)
}
\arguments{
\item{d}{An \eqn{n\times n} square distance matrix
containing the intercentroid distance between the
\eqn{n} region centroids.}

\item{pop}{The population size associated with each
region.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}
}
\value{
Returns the indices of the nearest neighbors as a
  list.  For each element of the list, the indices are
  ordered from nearest to farthest from each centroid.
}
\description{
\code{scan.nn} determines the nearest
neighbors for a set of observations based on the
distance matrix according to a population-based
upperbound.
}
\details{
This function determines the nearest neighbors of each
centroid based on the intercentroid distance.  The number
of nearest neighbors is limited by the sum of the
population values among the nearest neighbors.  The set
of nearest neighbors can contain no more than \code{ubpop
* sum(pop)} members of the population.  The nearest
neighbors are ordered from nearest to farthest.
}
\examples{
data(nydf)
coords <- as.matrix(nydf[, c("longitude", "latitude")])
d <- as.matrix(dist(coords))
nn <- scan.nn(d, pop = nydf$pop, ubpop = 0.1)
}
\author{
Joshua French
}
