% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smerc_cluster-summary.R
\name{summary.smerc_cluster}
\alias{summary.smerc_cluster}
\title{Summary of \code{smerc_cluster} object}
\usage{
\method{summary}{smerc_cluster}(object, ..., idx = seq_along(object$clusters), digits = 1)
}
\arguments{
\item{object}{An object of class \code{smerc_cluster}.}

\item{...}{
  Arguments passed on to \code{\link[base:summary]{base::summary}}
  \describe{
    \item{\code{}}{}
  }}

\item{idx}{A index vector indicating the elements of
\code{object$clusters} to print information for. The default
is all clusters.}

\item{digits}{Integer indicating the number of decimal places.}
}
\description{
Summary of object of class \code{smerc_cluster}.
}
\examples{
data(nydf)
coords = with(nydf, cbind(x, y))
out = scan.test(coords = coords, cases = floor(nydf$cases),
                pop = nydf$pop, nsim = 49,
                longlat = TRUE, alpha = 0.12)
summary(out)
}
