% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.clusters.R
\name{color.clusters}
\alias{color.clusters}
\title{Color clusters}
\usage{
color.clusters(x, col = 2:(length(x$clusters) + 1))
}
\arguments{
\item{x}{An object of class scan produced by a function
such as \code{scan.test}.}

\item{col}{A vector of colors to color the clusters in
\code{x}.  Should have same length as the number of
clusters in \code{x}.}
}
\value{
Returns a vector with colors for each
  region/centroid for the data set used to construct
  \code{x}.
}
\description{
\code{color.clusters} is a helper function to color
clusters of regions produced by an appropriate method,
e.g., \code{scan.test} or \code{uls.test}.  Regions that
are not part of any cluster have no color.
}
\examples{
data(nydf)
coords = with(nydf, cbind(longitude, latitude))
out = scan.test(coords = coords, cases = floor(nydf$cases),
                pop = nydf$pop, alpha = 0.12, longlat = TRUE,
                nsim = 9)
data(nypoly)
library(sp)
plot(nypoly, col = color.clusters(out))
}
\author{
Joshua French
}
