% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/flex.zones.R
\name{flex.zones}
\alias{flex.zones}
\title{Determine zones for flexibly shaped spatial scan test}
\usage{
flex.zones(coords, w, k = 10, lonlat = FALSE)
}
\arguments{
\item{coords}{The number of cases in each region.}

\item{w}{The binary spatial adjacency matrix.}

\item{k}{The maximum number of regions to include in a zone.}

\item{lonlat}{A logical indioating whether the coordinates are longitude/latitude.  If so, the great circle distance is used in computing the nearest/neighbor distance matrix.}
}
\value{
Returns a list of zones to consider for clustering.  Each element of the list contains a vector with the location ids of the regions in that zone.
}
\description{
\code{flex.zones} determines the unique zones to consider for the flexibly shaped spatial scan test of Tango and Takahashi (2005).
}
\examples{
data(nydf)
data(nyw)
coords = cbind(nydf$longitude, nydf$latitude)
flex.zones(coords = coords, w = nyw, k = 3, lonlat = TRUE)
}
\author{
Joshua French
}
\references{
Tango, T., & Takahashi, K. (2005). A flexibly shaped spatial scan statistic for detecting clusters. International journal of health geographics, 4(1), 11.
}

