% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/smbinning.R
\name{chileancredit}
\alias{chileancredit}
\title{Chilean Credit Data}
\format{Data frame with 29,519 rows and 57 columns.}
\description{
A simulated dataset based on six months of information collected by a Chilean Bank
whose objective was to develop a credit scoring model to determine the probability
of default within the next 12 months. The target
variable is FlagGB, which represents the binary status of default (0) and not default(1).
}
\details{
\itemize{
  \item CustomerId. Customer Identifier.
  \item TOB. Time on books in months since first account was open.
  \item IncomeLevel. Income level from 00 (Low) to 05 (High).
  \item RevAccts. Number of open revolving accounts.
  \item InsAccs. Number of open installment accounts.
  \item RevBal. Outstanding balance in all open revolving accounts
  \item InsBal. Outstanding balance in all open installment accounts
  \item RevLim. Limit of all open revolving accounts
  \item SavingsAmtL3M. Amount saved in the last 3 months.
  \item Bal. Outstanding balance
  \item MaxDqBin. Max. delinquency bin. 0:No Dq., 1:1-29 ... 6:150-179.
  \item BureauBalDq1st. Outstanding balance 30-89 in Credit Bureau.
  \item BureauBalDq2nd.Outstanding balance 90-179 in Credit Bureau.
  \item BureauBalDq3rd.Outstanding balance 180+ in Credit Bureau.
  \item CntOtherLenders. Numer of other lenders (Credit Bureau).
  \item MtgBal. Mortgage outstanding balance at the Credit Bureau.
  \item NonBankTradesDq. Number of non-bank delinquent trades.
  \item Performance. Scoring model performance definition.
  \item CatGBI. Exclusion (NULL), Bad (00), Indet. (01), Good (02).
  \item FlagGB. 1: Good, 0: Bad.
  \item Random. Uniformly distributed random value for sampling purposes.
  \item FlagSample. Training and test sample indicator (1:75\%,0:25\%).
  }
}

