% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qnn.test.R
\name{qnn.test}
\alias{qnn.test}
\title{q Nearest Neighbors Test}
\usage{
qnn.test(x, q = 5, nsim = 499, case = 2, longlat = FALSE)
}
\arguments{
\item{x}{A \code{ppp} object from the \code{spatstat}
package with marks for the case and control groups.}

\item{q}{A vector of positive integers indicating the
values of \code{q} for which to do the q nearest
neighbors test.}

\item{nsim}{The number of simulations from which to
compute p-value.}

\item{case}{The position of the name of the "case" group
in levels(x$marks).  The default is 2.}

\item{longlat}{A logical value indicating whether
Euclidean distance (\code{FALSE}) or Great Circle
(WGS84 ellipsoid, \code{FALSE}) should be used. 
Default is \code{FALSE}, i.e., Euclidean distance.}
}
\value{
Returns a list with the following components: 
  \item{qsum}{A dataframe with the number of neighbors
  (q), test statistic (Tq), and p-value for each test.} 
  \item{consum}{A dataframe with the contrasts
  (contrast), test statistic (Tcon), and p-value
  (pvaluecon) for the test of contrasts.}
}
\description{
\code{qnn.test} calculates statistics related to the q
nearest neighbors method of comparing case and control
point patterns under the random labeling hypothesis.
}
\examples{
data(grave)
qnn.test(grave, q = c(3, 5, 7, 9, 11, 13, 15))
}
\references{
Waller, L.A., and Gotway, C.A. (2005). 
Applied Spatial Statistics for Public Health Data. 
Hoboken, NJ: Wiley.

Cuzick, J., and Edwards, R. (1990). Spatial clustering
for inhomogeneous populations. Journal of the Royal
Statistical Society. Series B (Methodological), 73-104.

Alt, K.W., and Vach, W. (1991). The reconstruction of
"genetic kinship" in prehistoric burial
complexes-problems and statistics. Classification, Data
Analysis, and Knowledge Organization, 299-310.
}
\author{
Joshua French
}
