% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wait.R
\name{wait_slurm}
\alias{wait_slurm}
\alias{wait_slurm.slurm_job}
\alias{wait_slurm.integer}
\title{Wait for a Slurm job to be completed}
\usage{
wait_slurm(x, ...)

\method{wait_slurm}{slurm_job}(x, ...)

\method{wait_slurm}{integer}(x, timeout = -1, freq = 0.1, force = TRUE, ...)
}
\arguments{
\item{x}{Either a job id number, or an object of class \link{slurm_job}.}

\item{...}{Further arguments passed to the method}

\item{timeout}{Integer. Maximum wait time in seconds. If \code{timeout < 0}
then the command will only return when the job finishes.}

\item{freq}{Frequency in seconds to query for the state of the job.}

\item{force}{Logical scalar. When \code{TRUE}, if the job is not found
after checking for its status, the function will continue to wait
still.}
}
\value{
Invisible \code{NULL}.
}
\description{
Wait for a Slurm job to be completed
}
\examples{
# Waiting is only available if there are Slurm clusters
if (slurm_available()) {
  job <- Slurm_EvalQ(Sys.sleep(1000), plan = "submit", njobs = 2)
  wait_slurm(job, timeout = 1) # This will return a warning
  scancel(job)   
  Slurm_clean(job)
}
}
