% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_recapitate}
\alias{ts_recapitate}
\title{Recapitate the tree sequence}
\usage{
ts_recapitate(
  ts,
  recombination_rate,
  Ne = NULL,
  demography = NULL,
  random_seed = NULL
)
}
\arguments{
\item{ts}{Tree sequence object loaded by \code{ts_load}}

\item{recombination_rate}{A constant value of the recombination rate}

\item{Ne}{Effective population size during the recapitation process}

\item{demography}{Ancestral demography to be passed internally to
\code{msprime.sim_ancestry()} (see msprime's documentation for mode detail)}

\item{random_seed}{Random seed passed to pyslim's \code{recapitate} method}
}
\value{
Tree-sequence object of the class \code{slendr_ts}, which serves as
an interface point for the Python module tskit using slendr functions with
the \code{ts_} prefix.
}
\description{
Recapitate the tree sequence
}
\examples{
\dontshow{check_dependencies(python = TRUE) # make sure dependencies are present
}
# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

ts <-
  ts_load(slendr_ts, model) \%>\%
  ts_recapitate(recombination_rate = 1e-8, Ne = 10000, random_seed = 42)

ts
}
\seealso{
\code{\link{ts_nodes}} for extracting useful information about
individuals, nodes, coalescent times and geospatial locations of nodes on a
map
}
