% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{param}
\alias{param}
\alias{param.slcafit}
\title{Print Estimated Parameters of an \code{slcafit} Object}
\usage{
param(object, ...)

\method{param}{slcafit}(
   object, type = c("probs", "logit"),
   se = FALSE, index = FALSE, ...
)
}
\arguments{
\item{object}{an object of class \code{slcafit}.}

\item{...}{additional arguments passed to other methods.}

\item{type}{a character string specifying the format in which the estimated parameters should be displayed. The options are \code{"probs"} for probability format or \code{"logit"} for log-odds (logit) format. The default setting is \code{"probs"}.}

\item{se}{a logical value indicating whether to display standard errors (\code{TRUE}) or parameter estimates (\code{FALSE}). The default is \code{FALSE}.}

\item{index}{a logical value indicating whether to include (\code{TRUE}) or exclude (\code{FALSE}) the indices of the estimated parameters in the output. The default is \code{FALSE}.}
}
\value{
A \code{list} containing the requested estimated parameters or their standard errors (if \code{se = TRUE}). The components of the list include:
\item{pi}{Membership probabilities for the root latent variable.}
\item{tau}{Conditional probabilities between latent class variables, represented with uppercase letters to account for measurement invariance.}
\item{rho}{Item response probabilities for each measurement model, represented with lowercase letters to account for measurement invariance.}
}
\description{
Prints the estimated parameters of an \code{slca} model using an \code{slcafit} object.
}
