% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.slca.R
\name{simulate.slca}
\alias{simulate.slca}
\title{Simulate data from \code{slca} model.}
\usage{
\method{simulate}{slca}(object, nsim = 500, seed = NULL, parm, nlevel, ...)
}
\arguments{
\item{object}{a \code{slca} object representing the model from which data will be simulated.}

\item{nsim}{the number of response observations to simulate. Defaults to 500.}

\item{seed}{a random seed for reproducibility of the}

\item{parm}{a set of parameters provided by the user to guide the simulation, if the model has not been estimated.}

\item{nlevel}{the number of levels for each manifest item declared in the model. If not provided, the default is 2.}

\item{...}{additional arguments.}
}
\value{
A \code{list} of two components:
\item{class}{A \code{data.frame} providing the assigned latent class for each individual across different latent class variables.}
\item{response}{A \code{data.frame} containing the manifest items that were simulated.}
}
\description{
This function simulates data from a constructed \code{slca} model. If the model is not already estimated, parameters can be specified by the user or generated randomly.
}
\examples{
library(magrittr)
model <- slca(lc1[3] ~ x1 + x2 + x3 + x4 + x5)
sim_data <- model \%>\% simulate(nlevel = c(3, 3, 3, 3, 3))
y <- sim_data$response
sapply(y, table)

sim_data <- model \%>\%
   simulate(nlevel = c(x1 = 2, x3 = 3, x4 = 4, x5 = 5))
y <- sim_data$response
sapply(y, table)

model <- slca(lc1[3] ~ x1 + x2 + x3 + x4 + x5,
              lc2[4] ~ y1 + y2 + y3 + y4 + y5)
sim_data <- model \%>\% simulate(1000)
sapply(sim_data$class, table)
}
