% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_upload.R
\name{slackr_upload}
\alias{slackr_upload}
\title{Send a file to Slack}
\usage{
slackr_upload(
  filename,
  title = basename(filename),
  initial_comment = basename(filename),
  channels = Sys.getenv("SLACK_CHANNEL"),
  bot_user_oauth_token = Sys.getenv("SLACK_BOT_USER_OAUTH_TOKEN")
)
}
\arguments{
\item{filename}{path to file}

\item{title}{title on Slack (optional - defaults to filename)}

\item{initial_comment}{comment for file on slack (optional - defaults to filename)}

\item{channels}{Slack channels to save to (optional)}

\item{bot_user_oauth_token}{Slack bot user OAuth token}
}
\value{
\code{httr} response object from \code{POST} call (invisibly)

\code{httr} response object from \code{POST} call (invisibly)
}
\description{
\code{slackr_upload} enables you upload files to Slack and
(optionally) post them to one or more channels (if \code{channels} is not empty).
}
\references{
\url{https://github.com/mrkaye97/slackr/pull/15/files}
}
\seealso{
\code{\link[=slackr_setup]{slackr_setup()}}, \code{\link[=slackr_dev]{slackr_dev()}}, \code{\link[=slackr_save]{slackr_save()}}
}
\author{
Quinn Weber (ctb), Bob Rudis (aut)
}
