% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fds.R
\name{plot_fds}
\alias{plot_fds}
\title{Fraction of Design Space Plot}
\usage{
plot_fds(genoutput, model = NULL, continuouslength = 11)
}
\arguments{
\item{genoutput}{The design, or the output of the power evaluation functions.}

\item{model}{The model, by default uses the model used in eval_design or gen_design.}

\item{continuouslength}{Default 9. The precision of the continuous variables.}
}
\value{
Plots design diagnostics
}
\description{
Creates a fraction of design space plot
}
\examples{
#We can pass either the output of gen_design or eval_design to plot_correlations
#in order to obtain the correlation map. Passing the output of eval_design is useful
#if you want to plot the correlation map from an externally generated design.

#First generate the design:

candidatelist = expand.grid(X1 = c(1, -1), X2 = c(1, -1))

design = gen_design(candidatelist, ~(X1 + X2), 15)

plot_fds(design)
}
