% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{skipTrack.results}
\alias{skipTrack.results}
\title{Get tables of Inference results from skipTrack.fit}
\usage{
skipTrack.results(stFit, trueVals = NULL, burnIn = 750)
}
\arguments{
\item{stFit}{Object result of skipTrack.fit function.}

\item{trueVals}{Optional named list containing true values for Betas, Gammas, and cijs. (Also can use output of skipTrack.simulate)}

\item{burnIn}{Number of MCMC iterations to discard as burn-in per chain.}
}
\value{
A list containing the following elements:
\item{Betas}{data.frame with 95\% credible intervals and (if trueVals is supplied) true values for Betas and Coverage tag.}
\item{Gammas}{data.frame with 95\% credible intervals and (if trueVals is supplied) true values for Gammas and Coverage tag.}
\item{cijs}{data.frame with Wald-type 95\% confidence intervals and (if trueVals is supplied) true values for cijs and Coverage tags.}
\item{Diagnostics}{data.frame with ess and gelman-rubin diagnostics from genMCMCDiag package, for parameter sets 'Betas', 'Gammas' and 'cijs'.}
}
\description{
This function calculates inference results on Betas, Gammas, and cijs based on the provided MCMC results.
It returns summaries such as credible intervals for Betas, Gammas, wald-type confidence intervals for cijs, and Gelman-Rubin diagnostics for all 3.
Note that true values and converage are included in the output if trueVals is supplied, but otherwise not.
}
\examples{
#Simulated data
simDat <- skipTrack.simulate(n = 100, skipProb = c(.7, .2, .1))

#Run model fit (should typically run with much more than 50 reps)
modFit <- skipTrack.fit(Y = simDat$Y, cluster = simDat$cluster, chains = 2, reps = 50)
modFit

# If using simulated data (which includes access to ground truth):
#
skipTrack.results(modFit, trueVals = simDat, burnIn = 25)
#Recommended burnIn with real data is at least 750
#
# If not using simulated data:
#
skipTrack.results(modFit, burnIn = 25)
#Recommended burnIn with real data is at least 750

}
