% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_functions.R
\name{skills}
\alias{skills}
\title{Pull from Skills API endpoint.}
\usage{
skills(
  text,
  depth = NULL,
  cutoff = NULL,
  socs = NULL,
  similarity_scoring = NULL,
  token,
  handle_status = "warn",
  response_raw = FALSE
)
}
\arguments{
\item{text}{Sentence or text entry to pull competencies for}

\item{depth}{Numeric vlaue specifying algorithm depth (Optional)}

\item{cutoff}{Numeric cutoff value (Optional)}

\item{socs}{Character vector of SOCs to fine-tune search (Optional)}

\item{similarity_scoring}{String specifying \code{true} or \code{false} 
Whether or not to use similarity scoring. (Optional)}

\item{token}{Authorization token obtained from \code{get_access_token}}

\item{handle_status}{How to handle bad HTTP status. Set as either \code{warn} or \code{error}}

\item{response_raw}{Logical value whether to return the API response as
raw, unparsed text. Defaults to \code{FALSE}}
}
\value{
A list of length 2; skills data relevant to query
}
\description{
Pull from Skills API endpoint.
}
\examples{
\dontrun{
tkn <- get_access_token(client_id, client_secret)
txt <- "Provide substance abuse education and counseling for at-risk individuals."
s <- skills(text = txt,
            depth = 20,
            cutoff = 5,
            token = tkn,
            similarity_scoring = "true")
}
}
