% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface-source_file.R
\name{source_r}
\alias{source_r}
\title{Source a 'sketch' R file}
\usage{
source_r(
  file,
  debug = FALSE,
  launch_browser = "viewer",
  asset_tags = default_tags(),
  ...
)
}
\arguments{
\item{file}{A character string; path to the R file.}

\item{debug}{TRUE or FALSE; if TRUE, a console for debugging is attached to your app.}

\item{launch_browser}{A character string; "viewer" or "browser", which
calls `rstudioapi::viewer` and `utils::browserURL` respectively; use
NULL to suppress display.}

\item{asset_tags}{An optional list of 'shiny.tag' objects to be added to the html
template. The list must have signature / structure of a named list:
    \code{[head = [shiny.tag], body = [shiny.tag]]},}

\item{...}{Additional arguments to pass to `compile_r`.}
}
\description{
This function compiles a 'sketch' R file, resolves the
dependencies and serves it in the viewer.
}
\examples{
\dontrun{
file <- system.file("test_files/test_source.R", package = "sketch")
# The next line launches the default HTML browser
source_r(file, debug = TRUE, launch_browser = "browser")
}

}
