% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zhou_etal.R
\name{zhou_etal}
\alias{zhou_etal}
\title{Zhou, Song, and Thompson's Test for Heteroskedasticity in a Linear Regression Model}
\usage{
zhou_etal(
  mainlm,
  auxdesign = NA,
  method = c("pooled", "covariate-specific", "hybrid"),
  Bperturbed = 500L,
  seed = 1234,
  statonly = FALSE
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{auxdesign}{A \code{\link[base]{data.frame}} or
\code{\link[base]{matrix}} representing an auxiliary design matrix of
containing exogenous variables that (under alternative hypothesis) are
related to error variance, or a character "fitted.values" indicating
that the fitted \eqn{\hat{y}_i} values from OLS should be used.
If set to \code{NA} (the default), the
design matrix of the original regression model is used. An intercept
is included in the auxiliary regression even if the first column of
\code{auxdesign} is not a vector of ones.}

\item{method}{A character specifying which of the three test methods to
implement; one of \code{"pooled"}, \code{"covariate-specific"}, or
\code{"hybrid"} (which combines the other two). Partial matching is
used.}

\item{Bperturbed}{An integer specifying the number of perturbation samples
to generate when estimating the \eqn{p}-value. Defaults to \code{500L}.}

\item{seed}{An integer specifying a seed to pass to
\code{\link[base]{set.seed}} for random number generation. This allows
for reproducibility of perturbation sampling. A value of \code{NA}
results in not setting a seed.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} "htest". If object is not
   assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the methods of
   \insertCite{Zhou15;textual}{skedastic} for testing for
   heteroskedasticity in a linear regression model.
}
\details{
\insertCite{Zhou15;textual}{skedastic} The authors propose
   three variations based on comparisons between sandwich and model-based
   estimators for the variances of individual regression coefficient
   esimators. The covariate-specific method computes a test statistic and
   \eqn{p}-value for each column of the auxiliary design matrix (which is,
   by default, the original design matrix with intercept omitted). The
   \eqn{p}-values undergo a Bonferroni correction to control overall test
   size. When the null hypothesis is rejected in this case, it also provides
   information about which auxiliary design variable is associated with the
   error variance. The pooled method computes a single test statistic and
   \eqn{p}-value and is thus an omnibus test. The hybrid method returns the
   minimum \eqn{p}-value between the Bonferroni-corrected covariate-specific
   \eqn{p}-values and the pooled \eqn{p}-value, multiplying it by 2 for a
   further Bonferroni correction. The test statistic returned is that
   which corresponds to the minimum \eqn{p}-value. The covariate-specific
   and pooled test statistics have null distributions that are
   asymptotically normal with mean 0. However, the variance is intractable
   and thus perturbation sampling is used to compute \eqn{p}-values
   empirically.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
zhou_etal(mtcars_lm, method = "pooled")
zhou_etal(mtcars_lm, method = "covariate-specific")
zhou_etal(mtcars_lm, method = "hybrid")

}
\references{
{\insertAllCited{}}
}
