% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horn.R
\name{horn}
\alias{horn}
\title{Horn's Test for Heteroskedasticity in a Linear Regression Model}
\usage{
horn(
  mainlm,
  deflator = NA,
  restype = c("ols", "blus"),
  alternative = c("two.sided", "greater", "less"),
  exact = (nres <= 10),
  statonly = FALSE,
  ...
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{deflator}{Either a character specifying a column name from the
design matrix of \code{mainlm} or an integer giving the index of a
column of the design matrix. This variable is suspected to be
related to the error variance under the alternative hypothesis.
\code{deflator} may not correspond to a column of 1's (intercept).
Default \code{NA} means the data will be left in its current order
(e.g. in case the existing index is believed to be associated with
error variance).}

\item{restype}{A character specifying which residuals to use: \code{"ols"}
for OLS residuals (the default) or the \code{"blus"} for
\link[=blus]{BLUS} residuals. The advantage of using BLUS residuals is
that, under the null hypothesis, the assumption that the random series
is independent and identically distributed is met (whereas with OLS
residuals it is not). The disadvantage of using BLUS residuals is that
only \eqn{n-p} residuals are used rather than the full \eqn{n}.}

\item{alternative}{A character specifying the form of alternative
hypothesis; one of \code{"two.sided"} (default), \code{"greater"},
or \code{"less"}. \code{"two.sided"} corresponds to any trend in the
absolute residuals when ordered by \code{deflator}. \code{"greater"}
corresponds to a negative trend in the absolute residuals when ordered by
\code{deflator}. \code{"less"} corresponds to a positive trend in the
absolute residuals when ordered by \code{deflator}. (Notice that \eqn{D}
tends to be small when there is a positive trend.)}

\item{exact}{A logical. Should exact \eqn{p}-values be computed? If
\code{FALSE}, a normal approximation is used. Defaults to \code{TRUE}
only if the number of absolute residuals being ranked is \eqn{\le 10}.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}

\item{...}{Optional further arguments to pass to \code{\link{blus}}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the nonparametric test of
   \insertCite{Horn81;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
The test entails specifying a 'deflator', an explanatory variable
   suspected of being related to the error variance. Residuals are ordered
   by the deflator and the nonparametric trend statistic
   \eqn{D=\sum (R_i - i)^2} proposed by
   \insertCite{Lehmann75;textual}{skedastic} is
   then computed on the absolute residuals and used to test for an
   increasing or decreasing trend, either of which would correspond to
   heteroskedasticity. Exact probabilities for the null distribution of
   \eqn{D} can be obtained from functions \code{\link{dDtrend}} and
   \code{\link{pDtrend}}, but since computation time increases rapidly with
   \eqn{n}, use of a normal approximation is recommended for \eqn{n>10}.
   \insertCite{Lehmann75;textual}{skedastic} proves that \eqn{D} is
   asymptotically normally distributed and the approximation of the
   statistic \eqn{Z=(D-E(D))/\sqrt{V(D)}} to the standard normal
   distribution is already quite good for \eqn{n=11}.

   The expectation and variance of \eqn{D} (when ties are absent) are
   respectively \eqn{E(D)=\frac{n^3-n}{6}} and
   \eqn{V(D)=\frac{n^2(n+1)^2(n-1)}{36}}; see
   \insertCite{Lehmann75;textual}{skedastic} for \eqn{E(D)} and \eqn{V(D)}
   when ties are present. When ties are absent, a continuity correction
   is used to improve the normal approximation. When
   exact distribution is used, two-sided \eqn{p}-value is computed by
   doubling the one-sided \eqn{p}-value, since the distribution of \eqn{D}
   is symmetric. The function does not support the exact distribution of
   \eqn{D} in the presence of ties, so in this case the normal approximation
   is used regardless of \eqn{n}.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
horn(mtcars_lm, deflator = "qsec")
horn(mtcars_lm, deflator = "qsec", restype = "blus")

}
\references{
{\insertAllCited{}}
}
