% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overdisp.R
\name{overdisp}
\alias{overdisp}
\alias{zero_count}
\title{Check overdispersion of GL(M)M's}
\usage{
overdisp(x, trafo = NULL)

zero_count(x)
}
\arguments{
\item{x}{Fitted GLMM (\code{\link[lme4]{merMod}}-class) or \code{glm} model.}

\item{trafo}{A specification of the alternative, can be numeric or a
(positive) function or \code{NULL} (the default). See 'Details'
in \code{\link[AER]{dispersiontest}} in package \CRANpkg{AER}. Does not
apply to \code{merMod} objects.}
}
\value{
For \code{overdisp()}, information on the overdispersion test; for
        \code{zero_count()}, the amount of predicted and observed zeros in
        the outcome, as well as the ratio between these two values.
}
\description{
\code{overdisp()} checks generalized linear (mixed) models for
             overdispersion, while \code{zero_count()} checks whether models
             from poisson-families are over- or underfitting zero-counts in
             the outcome.
}
\details{
For \code{merMod}- and \code{glmmTMB}-objects, \code{overdisp()} is
         based on the code in the \href{http://glmm.wikidot.com/faq}{DRAFT r-sig-mixed-models FAQ},
         section \emph{How can I deal with overdispersion in GLMMs?}.
         Note that this function only returns an \emph{approximate} estimate
         of an overdispersion parameter, and is probably inaccurate for
         zero-inflated mixed models (fitted with \code{glmmTMB}).
         \cr \cr
         For \code{glm}'s, \code{overdisp()} simply wraps the \code{dispersiontest}
         from the \pkg{AER}-package.
}
\note{
For the overdispersion-test, the interpretation of the returned p-value
      differs between GLM and GLMM. For GLMs, a p-value < .05 indicates
      overdispersion, while for GLMMs, a p-value > .05 indicates overdispersion.
      \cr \cr
      For \code{zero_count()}, a model that is underfitting zero-counts
      indicates a zero-inflation in the data, i.e. it is recommended to
      use negative binomial or zero-inflated models then.
}
\examples{
library(sjmisc)
data(efc)

# response has many zero-counts, poisson models
# might be overdispersed
barplot(table(efc$tot_sc_e))

fit <- glm(tot_sc_e ~ neg_c_7 + e42dep + c160age,
           data = efc, family = poisson)
overdisp(fit)
zero_count(fit)

library(lme4)
efc$e15relat <- to_factor(efc$e15relat)
fit <- glmer(tot_sc_e ~ neg_c_7 + e42dep + c160age + (1 | e15relat),
             data = efc, family = poisson)
overdisp(fit)
zero_count(fit)


}
\references{
\href{http://glmm.wikidot.com/faq}{DRAFT r-sig-mixed-models FAQ}
            \cr \cr
            Bolker B et al. (2017): \href{http://bbolker.github.io/mixedmodels-misc/glmmFAQ.html}{GLMM FAQ.}
}
