% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frq.R
\name{frq}
\alias{frq}
\title{Frequencies of labelled variables}
\usage{
frq(x, sort.frq = c("none", "asc", "desc"))
}
\arguments{
\item{x}{A labelled vector.}

\item{sort.frq}{Logical, if \code{TRUE}, rows will be sorted according to
value frequencies.}
}
\value{
A data frame with values, value labels, frequencies, raw, valid and
          cumulative percentages of \code{x}.
}
\description{
This function returns a frequency table of labelled vectors, as data frame.
}
\examples{
library(haven)
# create labelled integer
x <- labelled(c(1, 2, 1, 3, 4, 1),
              c(Male = 1, Female = 2, Refused = 3, "N/A" = 4))
frq(x)

x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1, 2:3),
              c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
frq(x)

# in a pipe
data(efc)
library(dplyr)
efc \%>\% select(e42dep, e15relat, c172code) \%>\% frq()

}
\seealso{
\code{\link{flat_table}} for labelled (proportional) tables.
}

