% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotStackFrequencies.R
\name{sjp.stackfrq}
\alias{sjp.stackfrq}
\title{Plot stacked proportional bars}
\usage{
sjp.stackfrq(items, legendLabels = NULL, sort.frq = NULL, weightBy = NULL,
  weightByTitleString = NULL, hideLegend = FALSE, title = NULL,
  legendTitle = NULL, includeN = TRUE, axisLabels.y = NULL,
  breakTitleAt = 50, breakLabelsAt = 30, breakLegendTitleAt = 30,
  breakLegendLabelsAt = 28, gridBreaksAt = 0.2, expand.grid = FALSE,
  geom.size = 0.5, geom.colors = "Blues", axisTitle.x = NULL,
  axisTitle.y = NULL, showValueLabels = TRUE, labelDigits = 1,
  vjust = "center", showPercentageAxis = TRUE, showItemLabels = TRUE,
  showSeparatorLine = FALSE, separatorLineColor = "grey80",
  separatorLineSize = 0.3, coord.flip = TRUE, printPlot = TRUE)
}
\arguments{
\item{items}{\code{\link{data.frame}} with each column representing one item.}

\item{legendLabels}{list or vector of strings that indicate the items' categories.
WIll also appear as legend text.}

\item{sort.frq}{indicates whether the \code{items} should be ordered by
by highest count of first or last category of \code{items}.
\describe{
  \item{\code{"first.asc"}}{to order ascending by lowest count of first category,}
  \item{\code{"first.desc"}}{to order descending by lowest count of first category,}
  \item{\code{"last.asc"}}{to order ascending by lowest count of last category,}
  \item{\code{"last.desc"}}{to order descending by lowest count of last category,}
  \item{\code{NULL}}{(default) for no sorting.}
}}

\item{weightBy}{weight factor that will be applied to weight all cases from \code{items}.
Must be a vector of same length as \code{nrow(items)}. Default is \code{NULL}, so no weights are used.}

\item{weightByTitleString}{suffix (as string) for the plot's title, if \code{weightBy} is specified,
e.g. \code{weightByTitleString=" (weighted)"}. Default is \code{NULL}, so plot's 
title will not have a suffix when cases are weighted.}

\item{hideLegend}{logical, indicates whether legend (guide) should be shown or not.}

\item{title}{plot's title}

\item{legendTitle}{title of plot's legend}

\item{includeN}{logical, if \code{TRUE} (default), the N of each item is included into axis labels.}

\item{axisLabels.y}{character vector with labels for the y-axis (variable names 
of \code{items}). Example: \code{axisLabels.y = c("Q1", "Q2", "Q3")}
Axis labels will automatically be detected, when they have
label attributes (see \code{\link[sjmisc]{set_label}}) for details).}

\item{breakTitleAt}{determines how many chars of the title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{determines how many chars of the category labels are displayed in 
one line and when a line break is inserted.}

\item{breakLegendTitleAt}{determines how many chars of the legend's title 
are displayed in one line and when a line break is inserted.}

\item{breakLegendLabelsAt}{determines how many chars of the legend labels are 
displayed in one line and when a line break is inserted.}

\item{gridBreaksAt}{set breaks for the axis, i.e. at every \code{gridBreaksAt}'th 
position a major grid is being printed. Valid values range from 0 to 1.}

\item{expand.grid}{logical, if \code{TRUE} (default), the diagram has margins, 
i.e. the y-axis is not exceeded to the diagram's boundaries.}

\item{geom.size}{size resp. width of the geoms (bar width)}

\item{geom.colors}{user defined color palette for geoms. If specified, must either be vector with color values 
of same length as groups defined in \code{legendLabels}, or a specific color palette code.
See 'Note' in \code{\link{sjp.grpfrq}}.}

\item{axisTitle.x}{title for the x-axis. Default is \code{NULL} (no title).}

\item{axisTitle.y}{title for the y-axis. Default is \code{NULL} (no title).}

\item{showValueLabels}{Whether counts and percentage values should be plotted to each bar.}

\item{labelDigits}{The amount of digits for rounding \code{value.labels}. Default is 1, 
i.e. value labels have 1 digit after decimal point.}

\item{vjust}{character vector, indicating the vertical position of value 
labels. Allowed are same values as for \code{vjust} aesthetics from 
\code{ggplot2}: "left", "center", "right", "bottom", "middle", "top" and
new options like "inward" and "outward", which align text towards and 
away from the center of the plot respectively.}

\item{showPercentageAxis}{If \code{TRUE} (default), the percentage values at the x-axis are shown.}

\item{showItemLabels}{Whether x axis text (category names) should be shown or not.}

\item{showSeparatorLine}{If \code{TRUE}, a line is drawn to visually "separate" each bar in the diagram.}

\item{separatorLineColor}{The color of the separator line. only applies, if \code{showSeparatorLine} is \code{TRUE}.}

\item{separatorLineSize}{The size of the separator line. only applies, if \code{showSeparatorLine} is \code{TRUE}.}

\item{coord.flip}{If \code{TRUE}, the x and y axis are swapped.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot items (variables) of a scale as stacked proportional bars. This
               function is useful when several items with identical scale/categoroies
               should be plotted to compare the distribution of answers.
}
\note{
Thanks to \href{http://www.clas.ufl.edu/users/forrest/}{Forrest Stevens} for bug fixes.
}
\examples{
# -------------------------------
# random sample
# -------------------------------
# prepare data for 4-category likert scale, 5 items
Q1 <- as.factor(sample(1:4, 500, replace = TRUE, 
                       prob = c(0.2, 0.3, 0.1, 0.4)))
Q2 <- as.factor(sample(1:4, 500, replace = TRUE, 
                       prob = c(0.5, 0.25, 0.15, 0.1)))
Q3 <- as.factor(sample(1:4, 500, replace = TRUE, 
                       prob = c(0.25, 0.1, 0.4, 0.25)))
Q4 <- as.factor(sample(1:4, 500, replace = TRUE, 
                       prob = c(0.1, 0.4, 0.4, 0.1)))
Q5 <- as.factor(sample(1:4, 500, replace = TRUE, 
                       prob = c(0.35, 0.25, 0.15, 0.25)))

likert_4 <- data.frame(Q1, Q2, Q3, Q4, Q5)

# create labels
levels_4 <- c("Independent", 
              "Slightly dependent", 
              "Dependent", 
              "Severely dependent")

# plot stacked frequencies of 5 (ordered) item-scales
sjp.stackfrq(likert_4, legendLabels = levels_4)


# -------------------------------
# Data from the EUROFAMCARE sample dataset
# -------------------------------
library(sjmisc)
data(efc)
# recveive first item of COPE-index scale
start <- which(colnames(efc) == "c82cop1")
# recveive first item of COPE-index scale
end <- which(colnames(efc) == "c90cop9")
# auto-detection of labels
sjp.stackfrq(efc[, c(start:end)])


}
\seealso{
\itemize{
             \item \href{http://www.strengejacke.de/sjPlot/sjp.stackfrq/}{sjPlot manual: sjp.stackfrq}
             \item \code{\link{sjt.stackfrq}}
             }
}

