% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotLinregMultiple.R
\name{sjp.lmm}
\alias{sjp.lmm}
\title{Plot coefficients of multiple fitted lm(er)'s}
\usage{
sjp.lmm(..., type = "lm", title = NULL, labelDependentVariables = NULL,
  legendDepVarTitle = "Dependent Variables", legendPValTitle = "p-level",
  stringModel = "Model", axisLabels.y = NULL, axisTitle.x = "Estimates",
  axisLimits = NULL, breakTitleAt = 50, breakLabelsAt = 25,
  breakLegendTitleAt = 20, gridBreaksAt = NULL, geom.size = 3,
  geom.spacing = 0.4, geom.colors = "Set1", fade.ns = FALSE,
  usePShapes = FALSE, interceptLineType = 2,
  interceptLineColor = "grey70", remove.estimates = NULL,
  coord.flip = TRUE, showIntercept = FALSE, showAxisLabels.y = TRUE,
  showValueLabels = TRUE, labelDigits = 2, showPValueLabels = TRUE,
  hideLegend = FALSE, facet.grid = FALSE, printPlot = TRUE)
}
\arguments{
\item{...}{one or more fitted \code{lm} or \code{lmerMod}-objects. May also 
be a \code{\link{list}}-object with  fitted models, instead of separating 
each model with comma. See 'Examples'.}

\item{type}{type of plot. Use one of following:
\describe{
  \item{\code{"lm"}}{(default) for forest-plot like plot of estimates.}
  \item{\code{"std"}}{for forest-plot like plot of standardized beta values.}
  \item{\code{"std2"}}{for forest-plot like plot of standardized beta values, however, standardization is done by rescaling estimates by dividing them by two sd (see 'Details' in \code{\link{sjp.lm}}).}
}}

\item{title}{diagram's title as string.}

\item{labelDependentVariables}{character vector with labels of dependent 
variables of all fitted models. See 'Examples'.}

\item{legendDepVarTitle}{character vector used for the legend title.
Default is \code{"Dependent Variables"}.}

\item{legendPValTitle}{character vector used for the title of the significance level's legend.
Default is \code{"p-level"}. Only applies if \code{usePShapes = TRUE}.}

\item{stringModel}{string, legend text for the model names in case no 
labels for the dependent variables are provided (see \code{labelDependentVariables}).
Default is \code{"Model"}.}

\item{axisLabels.y}{labels or names of the predictor variables (independent vars). Must
be a character vector of same length as independent variables. The labels
may also be passed as list object; they will be coerced to character vector automatically.}

\item{axisTitle.x}{string, title for the x axis.}

\item{axisLimits}{numeric vector of length 2, defining the range of the plot axis.
By default, the limits range from the lowest confidence interval to the 
highest, so plot has maximum zoom.}

\item{breakTitleAt}{determines how many chars of the plot title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{determines how many chars of the category labels are displayed in 
one line and when a line break is inserted.}

\item{breakLegendTitleAt}{determines how many chars of the legend's title 
are displayed in one line and when a line break is inserted.}

\item{gridBreaksAt}{set breaks for the axis, i.e. at every \code{gridBreaksAt}'th 
position a major grid is being printed.}

\item{geom.size}{size of the points that indicate the estimates. Default is 3.}

\item{geom.spacing}{spacing between the dots and error bars of the plotted fitted models. Default
is 0.3.}

\item{geom.colors}{colors for representing the estimates (i.e. points and error bars)
of the different fitted models. Thus, the length of this vector must be equal to
the length of supplied fitted models, so each model is represented by its own color.
See 'Note' in \code{\link{sjp.grpfrq}}.}

\item{fade.ns}{if \code{TRUE}, non significant estimates will be printed in slightly faded colors.}

\item{usePShapes}{If \code{TRUE}, significant levels are distinguished by different point shapes and a related
legend is plotted. Default is \code{FALSE}.}

\item{interceptLineType}{linetype of the intercept line (zero point). Default is \code{2} (dashed line).}

\item{interceptLineColor}{color of the intercept line. Default value is \code{"grey70"}.}

\item{remove.estimates}{character vector with coefficient names that indicate
which estimates should be removed from the plot.
\code{remove.estimates = "est_name"} would remove the estimate \emph{est_name}. Default
is \code{NULL}, i.e. all estimates are printed.}

\item{coord.flip}{logical, if \code{TRUE} (default), predictors are plotted along the y-axis and estimate
values are plotted on the x-axis.}

\item{showIntercept}{If \code{TRUE}, the intercept of the fitted model is also plotted.
Default is \code{FALSE}.}

\item{showAxisLabels.y}{Whether term names (predictor labels) should be shown or not.}

\item{showValueLabels}{logical, whether value labels should be plotted to each dot or not.}

\item{labelDigits}{amount of digits for rounding the estimates (see \code{showValueLabels}).
Default is 2, i.e. estimates have 2 digits after decimal point.}

\item{showPValueLabels}{Whether the significance levels of each coefficient should be appended
to values or not.}

\item{hideLegend}{logical, indicates whether legend (guide) should be shown or not.}

\item{facet.grid}{\code{TRUE} when each model should be plotted as single facet instead of 
an integrated single graph.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{data}).
}
\description{
Plot and compare coefficients (estimates) with confidence 
               intervals of  multiple fitted linear (mixed effects) models 
               in one plot. 
               Fitted models may have differing predictors, but only
               in a "stepwise" sense.
}
\note{
The fitted models may have differing predictors, but only in a 
        "stepwise" sense; i.e., models should share a common set of predictors,
        while some models may have additional predictors (e.g. added via
        the \code{\link[stats]{update}} function). See 'Examples'.
}
\examples{
# prepare dummy variables for binary logistic regression
# Now fit the models. Note that all models share the same predictors
# and only differ in their dependent variable
library(sjmisc)
data(efc)

# fit three models
fit1 <- lm(barthtot ~ c160age + c12hour + c161sex + c172code, data = efc)
fit2 <- lm(neg_c_7 ~ c160age + c12hour + c161sex + c172code, data = efc)
fit3 <- lm(tot_sc_e ~ c160age + c12hour + c161sex + c172code, data = efc)

# plot multiple models
sjp.lmm(fit1, fit2, fit3, facet.grid = TRUE)

# plot multiple models with legend labels and 
# point shapes instead of value labels
sjp.lmm(fit1, fit2, fit3,
         axisLabels.y = c("Carer's Age",
                          "Hours of Care", 
                          "Carer's Sex",
                          "Educational Status"),
         labelDependentVariables = c("Barthel Index", 
                                     "Negative Impact", 
                                     "Services used"),
         showValueLabels = FALSE,
         showPValueLabels = FALSE,
         fade.ns = TRUE,
         usePShapes = TRUE)

# ------------------------------
# plot multiple models from nested lists argument
# ------------------------------
all.models <- list()
all.models[[1]] <- fit1
all.models[[2]] <- fit2
all.models[[3]] <- fit3

sjp.lmm(all.models)

# ------------------------------
# plot multiple models with different
# predictors (stepwise inclusion),
# standardi estimates
# ------------------------------
fit1 <- lm(mpg ~ wt + cyl + disp + gear, data = mtcars)
fit2 <- update(fit1, . ~ . + hp)
fit3 <- update(fit2, . ~ . + am)

sjp.lmm(fit1, fit2, fit3, type = "std2")

}

