% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{get_val_labels}
\alias{get_val_labels}
\title{Retrieve value labels of a variable or an SPSS-imported data frame}
\usage{
get_val_labels(x)
}
\arguments{
\item{x}{a data frame with variables that have attached value labels (e.g.
from an imported SPSS data (see \code{\link{read_spss}})) or a variable
(vector) with attached value labels.}
}
\value{
Either a list with all value labels from the data frame's variables,
          or a string with the value labels, if \code{x} is a variable.
}
\description{
This function retrieves the value labels of an imported
               SPSS data set (via \code{\link{read_spss}}) and
               \itemize{
                 \item if \code{x} is a data frame, returns the all variable's value labels as \code{\link{list}} object
                 \item or, if \code{x} is a vector, returns the label as string.
                 }
}
\note{
This function only works with vectors that have value and variable
       labels attached. This is automatically done by importing SPSS data sets
       with the \code{\link{read_spss}} function and can manually be applied
       with the \code{\link{set_val_labels}} and \code{\link{set_var_labels}}
       functions. \cr \cr
       With attached value and variable labels, most functions of this package
       automatically detect labels and uses them as axis, legend or title labels
       in plots (\code{sjp.}-functions) respectively as column or row headers
       in table outputs (\code{sjt.}-functions). Use \code{options(autoSetValueLabels = FALSE)}
       and \code{options(autoSetVariableLabels = FALSE)} to turn off automatic
       label detection.
}
\examples{
# import SPSS data set
# mydat <- read_spss("my_spss_data.sav", enc="UTF-8")

# retrieve variable labels
# mydat.var <- get_var_labels(mydat)

# retrieve value labels
# mydat.val <- get_val_labels(mydat)

data(efc)
get_val_labels(efc$e42dep)
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
           \item \href{http://www.strengejacke.de/sjPlot/view_spss/}{sjPlot manual: inspecting (SPSS imported) data frames}
           \item \code{\link{read_spss}}
           \item \code{\link{write_spss}}
           \item \code{\link{to_label}}
           \item \code{\link{to_value}}
           \item \code{\link{to_fac}}
           \item \code{\link{set_val_labels}}
           \item \code{\link{get_var_labels}}
           \item \code{\link{set_var_labels}}
           }
}

