\name{sjt.df}
\alias{sjt.df}
\title{Show (description of) data frame as HTML table}
\usage{
sjt.df(df, describe = TRUE, file = NULL, alternateRowColors = FALSE,
  orderColumn = NULL, orderAscending = TRUE, title = NULL,
  repeatHeader = FALSE, stringVariable = "Variable", showType = FALSE,
  showRowNames = TRUE, showCommentRow = FALSE,
  commentString = "No comment...", hideProgressBar = FALSE,
  encoding = "UTF-8", CSS = NULL, useViewer = TRUE, no.output = FALSE)
}
\arguments{
  \item{df}{A data frame that should be printed.}

  \item{describe}{If \code{TRUE} (default), a description
  of the data frame's variables is given.  The description
  is retrieved from the \code{\link{describe}} function of
  the \code{\link{psych}} package. If this parameter is
  \code{FALSE}, the data frame's content (values) is
  shown.}

  \item{file}{The destination file, which will be in
  html-format. If no filepath is specified, the file will
  be saved as temporary file and openend either in the
  RStudio View pane or in the default web browser.}

  \item{alternateRowColors}{If \code{TRUE}, alternating
  rows are highlighted with a light gray background color.}

  \item{orderColumn}{Indicates a column, either by column
  name or by column index number, that should be orderd.
  Default order is ascending, which can be changed with
  \code{orderAscending} parameter. Default is \code{NULL},
  hence the data frame is printed with no specific order.
  See examples for further details.}

  \item{orderAscending}{If \code{TRUE} (default) and
  \code{orderColumn} is not \code{NULL}, data frame is
  ordered according to the specified column in an ascending
  order.  Use \code{FALSE} to apply descending order. See
  examples for further details.}

  \item{title}{A table caption. By default, \code{title} is
  \code{NULL}, hence no title will be used.}

  \item{stringVariable}{A string used for the first column
  name. Default is \code{"Variable"}.}

  \item{repeatHeader}{If \code{TRUE}, the header row will
  also be added at the bottom at the table. This might be
  helpful, if you have longer tables and want to see the
  column names at the end of the table as well.}

  \item{showType}{If \code{TRUE}, the variable type is
  shown in a separate row below the column names.}

  \item{showRowNames}{If \code{TRUE} and \code{describe} is
  \code{false}, first table column contains row names of
  data frame. Use \code{showRowNames=FALSE} to omit first
  table column with row names.}

  \item{showCommentRow}{If \code{TRUE}, an optional comment
  line can be added to the end / below the table. Use
  \code{commentString} to specify the comment.}

  \item{commentString}{A string that will be added to the
  end / below the table. Only applies, if
  \code{showCommentRow} is \code{TRUE}.}

  \item{hideProgressBar}{If \code{TRUE}, the progress bar
  that is displayed when creating the table is hidden.
  Default in \code{FALSE}, hence the bar is visible.}

  \item{encoding}{The charset encoding used for variable
  and value labels. Default is \code{"UTF-8"}. Change
  encoding if specific chars are not properly displayed
  (e.g.) German umlauts).}

  \item{CSS}{A \code{\link{list}} with user-defined
  style-sheet-definitions, according to the official CSS
  syntax (see \url{http://www.w3.org/Style/CSS/}). See
  return value \code{page.style} for details of all
  style-sheet-classnames that are used in this function.
  Parameters for this list need: \enumerate{ \item the
  class-names with \code{"css."}-prefix as parameter name
  and \item each style-definition must end with a semicolon
  } You can add style information to the default styles by
  using a + (plus-sign) as initial character for the
  parameter attributes. Examples: \itemize{ \item
  \code{css.table='border:2px solid red;'} for a solid
  2-pixel table border in red.  \item
  \code{css.summary='font-weight:bold;'} for a bold
  fontweight in the summary row.  \item
  \code{css.arc='color:blue;'} for a blue text color each
  2nd row.  \item \code{css.caption='+color:red;'} to add
  red font-color to the default table caption style.  } See
  further examples below and
  \url{http://rpubs.com/sjPlot/sjtbasics}.}

  \item{useViewer}{If \code{TRUE}, the function tries to
  show the HTML table in the IDE's viewer pane. If
  \code{FALSE} or no viewer available, the HTML table is
  opened in a web browser.}

  \item{no.output}{If \code{TRUE}, the html-output is
  neither opened in a browser nor shown in the viewer pane
  and not even saved to file. This option is useful when
  the html output should be used in \code{knitr} documents.
  The html output can be accessed via the return value.}
}
\value{
Invisibly returns a \code{\link{structure}} with \itemize{
\item the data frame with the description information
(\code{data}), \item the web page style sheet
(\code{page.style}), \item the web page content
(\code{page.content}), \item the complete html-output
(\code{output.complete}) and \item the html-table with
inline-css for use with knitr (\code{knitr}) } for further
use.
}
\description{
Shows description or the content of data frame (rows and
columns) as HTML table, or saves it as file. Helpful if you
want a quick overview of a data frame's content. See
parameter \code{describe} for details. By default,
\code{describe} is \code{TRUE} and a description of the
data frame is given, using the \code{\link{describe}}
function of the \code{psych} package.
}
\examples{
# init dataset
data(efc)

# plot efc-data frame summary
\dontrun{
sjt.df(efc, alternateRowColors=TRUE)}

# plot content, first 50 rows of first 5 columns of example data set
\dontrun{
sjt.df(efc[1:50,1:5], describe=FALSE, stringVariable="Observation")}

# plot efc-data frame summary, ordered descending by mean-column
\dontrun{
sjt.df(efc, orderColumn="mean", orderAscending=FALSE)}

# plot first 20 rows of first 5 columns of example data set,
# ordered by column "e42dep" with alternating row colors
\dontrun{
sjt.df(efc[1:20,1:5], alternateRowColors=TRUE,
       orderColumn="e42dep", describe=FALSE)}

# plot first 20 rows of first 5 columns of example data set,
# ordered by 4th column in descending order.
\dontrun{
sjt.df(efc[1:20,1:5], orderColumn=4, orderAscending=FALSE, describe=FALSE)}

# ----------------------------------------------------------------
# User defined style sheet
# ----------------------------------------------------------------
\dontrun{
sjt.df(efc,
       alternateRowColor=TRUE,
       CSS=list(css.table="border: 2px solid #999999;",
                css.tdata="border-top: 1px solid;",
                css.arc="color:blue;"))}
}
\references{
\itemize{ \item
\url{http://strengejacke.wordpress.com/sjplot-r-package/}
\item
\url{http://strengejacke.wordpress.com/2014/03/04/beautiful-table-outputs-in-r-part-2-rstats-sjplot/}
}
}
\seealso{
\code{\link{sji.viewSPSS}}
}

