% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_tabla_tipos_event}
\alias{plot_tabla_tipos_event}
\title{Generar tabla con la distribución de casos por tipo de
enfermedad o evento}
\usage{
plot_tabla_tipos_event(data_agrupada, col_event = "nombre_evento")
}
\arguments{
\item{data_agrupada}{Un `data.frame` que contiene los datos de la
enfermedad o evento agrupados por tipo.}

\item{col_event}{Un `character` (cadena de caracteres) con el nombre de
la columna que contiene el tipo de evento en los datos agrupados de
la enfermedad o evento; su valor por defecto es `"nombre_evento"`.}
}
\value{
Una `kable` (tabla gráfica) con la distribución de casos
por tipo de enfermedad o evento.
}
\description{
Función que genera la tabla con la distribución de casos
por tipo de enfermedad o evento.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(dengue2020)
data_agrupada <- agrupar_eventos(
  data_event = data_limpia,
  col_event = "cod_eve"
)
plot_tabla_tipos_event(data_agrupada,
  col_event = "nombre_evento"
)
}
