% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking_data.R
\name{agrupar_mpio}
\alias{agrupar_mpio}
\title{Agrupar por municipios y casos}
\usage{
agrupar_mpio(
  data_event,
  dpto = NULL,
  col_mpio = "cod_mun_o",
  porcentaje = FALSE
)
}
\arguments{
\item{data_event}{Un `data.frame` que contiene los datos de la
enfermedad o evento.}

\item{dpto}{Un `character` (cadena de caracteres) o `numeric` (numérico)
que contiene el nombre del departamento; su valor por defecto es `NULL`.}

\item{col_mpio}{Un `character` (cadena de caracteres) con el nombre de
la columna que contiene los códigos de los municipios en los datos de la
enfermedad o evento; su valor por defecto es `"cod_mun_o"`.}

\item{porcentaje}{Un `logical` (TRUE o FALSE) que indica si se debe
agregar una columna con el porcentaje de casos; su valor por
defecto es `FALSE`.}
}
\value{
Un `data.frame` con los datos de la enfermedad o evento agrupados
por códigos de municipios y número de casos.
}
\description{
Función que agrupa los datos de una enfermedad o evento por
código de municipios y número de casos.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
agrupar_mpio(
  data_event = data_limpia,
  dpto = "ANTIOQUIA",
  col_mpio = "cod_mun_o",
  porcentaje = FALSE
)
agrupar_mpio(
  data_event = data_limpia,
  dpto = "05",
  col_mpio = "cod_mun_o",
  porcentaje = FALSE
)
agrupar_mpio(
  data_event = data_limpia,
  dpto = 05,
  col_mpio = "cod_mun_o",
  porcentaje = TRUE
)
}
