% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_segmentation.R
\name{sits_join_segments}
\alias{sits_join_segments}
\title{Return segments from a classified set of time series}
\usage{
sits_join_segments(data, segments)
}
\arguments{
\item{data}{A sits tibble with predicted values}

\item{segments}{A list of "sf" segments with polygon geometry
organized by tile.}
}
\value{
An list of sf objects of polygon geometry
                with an additional class attribute
                organized by tile
}
\description{
The \code{\link{sits_segment}} function produces
a list of "sf" segments. These segments are used to obtain a set
of time series (one per segment) using
\code{\link{sits_get_data}}. The time series can then be classified
using \code{\link{sits_classify}}. The next step is to add the result
of time series classification to the "sf" segments file. This action
is performed by this function.
}
\examples{
if (sits_run_examples()) {
data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
# create a data cube
cube <- sits_cube(
    source = "BDC",
    collection = "MOD13Q1-6",
    data_dir = data_dir
)

# segment the image
segments <- sits_segment(
    cube = cube,
    tile = "012010",
    bands = "NDVI",
    date = sits_timeline(cube)[1],
    seg_fn = sits_slic(step = 10)
)
# create a classification model
rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
# get the average value per segment
samples_seg <- sits_get_data(
    cube = cube,
    samples = segments
)
# classify the segments
seg_class <- sits_classify(
    data = samples_seg,
    ml_model = rfor_model
)
# add a column to the segments by class
sf_seg <- sits_join_segments(
    data = seg_class,
    segments = segments
)
}
}
\author{
Felipe Carvalho, \email{felipe.carvalho@inpe.br}
}
