% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_tae.R
\name{sits_tae}
\alias{sits_tae}
\title{Train a model using  Temporal Self-Attention Encoder}
\usage{
sits_tae(
  samples = NULL,
  samples_validation = NULL,
  epochs = 150,
  batch_size = 64,
  validation_split = 0.2,
  optimizer = torchopt::optim_adamw,
  opt_hparams = list(lr = 0.001, eps = 1e-08, weight_decay = 1e-06),
  lr_decay_epochs = 1,
  lr_decay_rate = 0.95,
  patience = 20,
  min_delta = 0.01,
  verbose = FALSE
)
}
\arguments{
\item{samples}{Time series with the training samples.}

\item{samples_validation}{Time series with the validation samples. if the
\code{samples_validation} parameter is provided,
the \code{validation_split} parameter is ignored.}

\item{epochs}{Number of iterations to train the model.}

\item{batch_size}{Number of samples per gradient update.}

\item{validation_split}{Number between 0 and 1. Fraction of training data
to be used as validation data.}

\item{optimizer}{Optimizer function to be used.}

\item{opt_hparams}{Hyperparameters for optimizer:
lr : Learning rate of the optimizer
eps: Term added to the denominator
     to improve numerical stability.
weight_decay:       L2 regularization}

\item{lr_decay_epochs}{Number of epochs to reduce learning rate.}

\item{lr_decay_rate}{Decay factor for reducing learning rate.}

\item{patience}{Number of epochs without improvements until
training stops.}

\item{min_delta}{Minimum improvement to reset the patience counter.}

\item{verbose}{Verbosity mode (TRUE/FALSE). Default is FALSE.}
}
\value{
A fitted model to be used for classification.
}
\description{
Implementation of Temporal Attention Encoder (TAE)
for satellite image time series classification.

This function is based on the paper by Vivien Garnot referenced below
and code available on github at
https://github.com/VSainteuf/pytorch-psetae.

We also used the code made available by Maja Schneider in her work with
Marco Körner referenced below and available at
https://github.com/maja601/RC2020-psetae.

If you use this method, please cite Garnot's and Schneider's work.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # create a TAE model
    torch_model <- sits_train(samples_modis_ndvi, sits_tae())
    # plot the model
    plot(torch_model)
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir,
        delim = "_",
        parse_info = c("X1", "tile", "band", "date")
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = torch_model, output_dir = tempdir()
    )
    # plot the probability cube
    plot(probs_cube)
    # smooth the probability cube using Bayesian statistics
    bayes_cube <- sits_smooth(probs_cube, output_dir = tempdir())
    # plot the smoothed cube
    plot(bayes_cube)
    # label the probability cube
    label_cube <- sits_label_classification(
        bayes_cube, output_dir = tempdir()
    )
    # plot the labelled cube
    plot(label_cube)
}
}
\references{
Vivien Garnot, Loic Landrieu, Sebastien Giordano, and Nesrine Chehata,
"Satellite Image Time Series Classification with Pixel-Set Encoders
and Temporal Self-Attention",
2020 Conference on Computer Vision and Pattern Recognition.
pages 12322-12331.
DOI: 10.1109/CVPR42600.2020.01234

Schneider, Maja; Körner, Marco,
"[Re] Satellite Image Time Series Classification
with Pixel-Set Encoders and Temporal Self-Attention."
ReScience C 7 (2), 2021.
DOI: 10.5281/zenodo.4835356
}
\author{
Charlotte Pelletier, \email{charlotte.pelletier@univ-ubs.fr}

Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}
}
