% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPeakTrough.R
\name{getPeakTrough}
\alias{getPeakTrough}
\title{Identify peaks and troughs of curve}
\usage{
getPeakTrough(x, y = NULL, peak = TRUE)
}
\arguments{
\item{x}{vector.}

\item{y}{vector.}

\item{peak}{logical determining whether peak or trough is returned.}
}
\value{
A length-2 vector containing the values of \code{x} and  \code{y}
at the peak or trough. If no peak/trough is identified \code{x} and  \code{y}
are set to NA.
}
\description{
Given vectors \code{x} and  \code{y}, returns their values at the peak or
trough of the curve, where dy/dx = 0.
}
\examples{
## create mean height velocity curve
data(heights)
m1 <- sitar(age, height, id, heights, 4)
x <- getCovariate(m1)
y <- fitted(m1, level=0)
y <- predict(smooth.spline(x, y), x, deriv=1)$y

## and plot it
. <- order(x)
plot(y[.] ~ x[.], type='l', xlab='age', ylab='height')
points(t(getPeakTrough(x, y)), pch=17)
points(t(getPeakTrough(x, y, peak=FALSE)), pch=25)
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
