% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_simulation.R
\name{mergeAlleleAbundance}
\alias{mergeAlleleAbundance}
\title{Merge the different allelic versions of the molecules.}
\usage{
mergeAlleleAbundance(df)
}
\arguments{
\item{df}{A dataframe with the abundance of the different molecules over time (from \code{\link{simulateInSilicoSystem}}
or \code{\link{simulateParallelInSilicoSystem}}).}
}
\value{
A dataframe in which the abundance of the different allelic versions of the same molecule have been merged to give the abundance of the molecule (without distinction of the allele of origin).
}
\description{
Merge (i.e. sum) the abundance of the different allelic versions of each molecule in the results of a simulation.
}
\examples{
\donttest{
mysystem = createInSilicoSystem(G = 5, empty = TRUE)
mypop = createInSilicoPopulation(1, mysystem, ploidy = 2)
sim = simulateInSilicoSystem(mysystem, mypop, 100)
head(sim$Simulation)
mergedAllelic = mergeAlleleAbundance(sim$Simulation)
head(mergedAllelic)
}
}
