% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sandwichMethods.R
\name{estfun.singleR}
\alias{estfun.singleR}
\alias{bread.singleR}
\alias{vcovHC.singleR}
\title{Heteroscedasticity-Consistent Covariance Matrix Estimation for singleR class}
\usage{
\method{estfun}{singleR}(x, ...)

\method{bread}{singleR}(x, ...)

\method{vcovHC}{singleR}(
  x,
  type = c("HC3", "const", "HC", "HC0", "HC1", "HC2", "HC4", "HC4m", "HC5"),
  omega = NULL,
  sandwich = TRUE,
  ...
)
}
\arguments{
\item{x}{a fitted \code{singleR} class object.}

\item{...}{for \code{vcovHC} additional optional arguments passed to the following functions:
\itemize{
\item \code{estfun} -- for empirical estimating functions.
\item \code{hatvalues} -- for diagonal elements of projection matrix.
\item \code{sandwich} -- only if \code{sandwich} argument in function call was set to \code{TRUE}.
\item \code{vcov} -- when calling \code{bread} internally.
}}

\item{type}{a character string specifying the estimation type, same as in \code{sandwich::vcovHC.default}. HC3 is the default value.}

\item{omega}{a vector or a function depending on the arguments residuals (i.e. the derivative of log-likelihood with respect to each linear predictor), diaghat (the diagonal of the corresponding hat matrix) and df (the residual degrees of freedom), same as in \code{sandwich::vcovHC.default}.}

\item{sandwich}{logical. Should the sandwich estimator be computed? If set to FALSE only the meat matrix is returned. Same as in \code{\link[sandwich:vcovHC]{sandwich::vcovHC()}}}
}
\value{
Variance-covariance matrix estimation corrected for heteroscedasticity of regression errors.
}
\description{
S3 method for \code{vcovHC} to handle \code{singleR} class objects.
Works exactly like \code{vcov.default} the only difference being that this method handles vector generalised linear models.
Updating the covariance matrix in variance/standard error estimation for population size estimator can be done via \code{\link[=redoPopEstimation]{redoPopEstimation()}}
}
\examples{
set.seed(1)
N <- 10000
gender <- rbinom(N, 1, 0.2)
eta <- -1 + 0.5*gender
counts <- rpois(N, lambda = exp(eta))
df <- data.frame(gender, eta, counts)
df2 <- subset(df, counts > 0)
mod1 <-  estimatePopsize(
  formula = counts ~ 1 + gender, 
  data = df2, 
  model = "ztpoisson", 
  method = "optim", 
  popVar = "analytic"
)
require(sandwich)
HC <- sandwich::vcovHC(mod1, type = "HC4")
Fisher <- vcov(mod1, "Fisher") # variance covariance matrix obtained from 
#Fisher (expected) information matrix
HC
Fisher
# usual results
summary(mod1)
# updated results
summary(mod1, cov = HC,
popSizeEst = redoPopEstimation(mod1, cov = HC))
# estimating equations
mod1_sims <- sandwich::estfun(mod1)
head(mod1_sims)
# bread method
all(vcov(mod1, "Fisher") * nrow(df2) == sandwich::bread(mod1, type = "Fisher"))
}
\seealso{
\code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} \code{\link[=redoPopEstimation]{redoPopEstimation()}}
}
\author{
Piotr Chlebicki, Maciej Beręsewicz
}
