% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/gen_process.cpp, src/gen_process.h
\name{gen_qn}
\alias{gen_qn}
\title{Generate a Quantisation Noise (QN) or Rounding Error Sequence}
\usage{
gen_qn(N, q2 = 0.1)
}
\arguments{
\item{N}{An \code{integer} for signal length.}

\item{q2}{A \code{double} that contains autocorrection.}
}
\value{
A \code{vec} containing the QN process.
}
\description{
Simulates a QN sequence given \eqn{Q^2}.
}
\section{Process Definition}{
 
Quantization Noise (QN) with parameter \eqn{Q^2 \in R^{+}}{Q^2 in R^{+}}. 
With i.i.d \eqn{Y_t \sim U(0,1)} (i.e. a standard uniform variable), this process is
defined as:

\deqn{X_t = \sqrt{12Q^2}(Y_{t}-Y_{t-1})}{X_t = sqrt(12*Q^2)*(Y[t]-Y[t-1])}
}

\section{Generation Algorithm}{

To generate the quantisation noise, we follow this recipe:
First, we generate using a random uniform distribution:
\deqn{U_k^*\sim U\left[ {0,1} \right]}{U_k^*~U[0,1]}

Then, we multiple the sequence by \eqn{\sqrt{12}}{sqrt(12)} so:
\deqn{{U_k} = \sqrt{12} U_k^*}{U_k = sqrt(12)*U_k^*}

Next, we find the derivative of \eqn{{U_k}}{U_k}
\deqn{{{\dot U}_k} = \frac{{{U_{k + \Delta t}} - {U_k}}}{{\Delta t}}}{U_k^. = (U_(k + (delta)t) - U_k)}

In this case, we modify the derivative such that:
\eqn{{{\dot U}_k}\Delta t = {U_{k + \Delta t}} - {U_k}}{U_k^. * (delta)t = U_{k + (delta)*t} - U_k}

Thus, we end up with:
\deqn{{x_k} = \sqrt Q {{\dot U}_k}\Delta t}{x_k = sqrt(Q)*U_k^.*(delta)t}
\deqn{{x_k} = \sqrt Q \left( {{U_{k + 1}} - {U_k}} \right)}{x_k = sqrt(Q)* (U_(k+1) - U_(k))}
}

\keyword{internal}
