% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params}
\alias{params}
\title{Parameters for sims functions}
\arguments{
\item{path}{A string of the path to the directory with the simulated data.}

\item{path_from}{A string of the path to the directory containing
the simulated datasets.}

\item{path_to}{A string of the path to the directory to copy
the simulated dataset to.}

\item{code}{A string of the JAGS or R code to generate the data.
The JAGS code must not be in a data or model block.}

\item{constants}{An nlist object (or list that can be coerced to nlist)
specifying the values of nodes in code.
The values are included in the output dataset.}

\item{parameters}{An nlist object (or list that can be coerced to nlist)
specifying the values of nodes in code.
The values are not included in the output dataset.}

\item{monitor}{A character vector (or regular expression if a string)
specifying the names of the nodes in code to include in the dataset.
By default all nodes are included.}

\item{stochastic}{A logical scalar specifying whether to monitor
deterministic and stochastic (NA), only deterministic (FALSE)
or only stochastic nodes (TRUE).}

\item{latent}{A logical scalar specifying whether to monitor
observed and latent (NA), only latent (TRUE)
or only observed nodes (FALSE).}

\item{nsims}{A whole number between 1 and 1,000,000 specifying
the number of data sets to simulate. By default 1 data set is simulated.}

\item{save}{A flag specifying whether to return the data sets as
an \code{nlists} object or save in \code{path}. If \code{save = NA}
the datasets are returned as an \code{nlists} object and saved in \code{path}.}

\item{exists}{A flag specifying whether the \code{path} directory should
already exist (if \code{exists = NA} it doesn't matter).}

\item{rdists}{A character vector specifying the R functions to recognize
as stochastic.}

\item{ask}{A flag specifying whether to ask before deleting sims
compatible files.}

\item{silent}{A flag specifying whether to suppress warnings.}
}
\description{
Descriptions of the parameters for the sims functions.
}
\keyword{internal}
