% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{impute_median}
\alias{impute_median}
\title{Impute (group-wise) medians}
\usage{
impute_median(dat, formula, add_residual = c("none", "observed", "normal"),
  type = 7, ...)
}
\arguments{
\item{dat}{\code{[data.frame]}, with variables to be imputed and their
predictors.}

\item{formula}{\code{[formula]} imputation model description (See Model description)}

\item{add_residual}{\code{[character]} Type of residual to add. \code{"normal"} 
means that the imputed value is drawn from \code{N(mu,sd)} where \code{mu}
and \code{sd} are estimated from the model's residuals (\code{mu} should equal
zero in most cases). If \code{add_residual = "observed"}, residuals are drawn
(with replacement) from the model's residuals. Ignored for non-numeric 
predicted variables.}

\item{type}{\code{[integer]} Specifies the algorithm to compute the median.
See the 'details' section of \code{\link[stats]{quantile}}.}

\item{...}{Currently not used.}
}
\description{
Impute medians of group-wise medians.
}
\section{Model Specification}{


Formulas are of the form

\code{IMPUTED_VARIABLES ~ MODEL_SPECIFICATION [ | GROUPING_VARIABLES ] }

The left-hand-side of the formula object lists the variable or variables to 
be imputed. Variables in \code{MODEL_SPECIFICATION} and/or 
\code{GROUPING_VARIABLES} are used to split the data set into groups prior to
imputation. Use \code{~ 1} to specify that no grouping is to be applied.
}

\examples{

# group-wise median imputation
irisNA <- iris
irisNA[1:3,1] <- irisNA[4:7,2] <- NA
a <- impute_median(irisNA, Sepal.Length ~ Species)
head(a)

# group-wise median imputation, all variables except species

a <- impute_median(irisNA, . - Species ~ Species)
head(a)

}
