% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex_tree.R
\name{collapse}
\alias{collapse}
\title{Elementary collapse}
\usage{
collapse(st, pair, w = NULL)
}
\arguments{
\item{st}{a simplex tree.}

\item{pair}{list of simplices to collapse.}

\item{w}{vertex to collapse to, if performing a vertex collapse.}
}
\value{
boolean indicating whether the collapse was performed.
}
\description{
Performs an elementary collapse.
}
\details{
This function provides two types of \emph{elementary collapses}. \cr 
\cr 
The first type of collapse is in the sense described by (1), which is 
summarized here. A simplex \eqn{\sigma} is said to be collapsible through one of its faces \eqn{\tau} if 
\eqn{\sigma} is the only coface of \eqn{\tau} (excluding \eqn{\tau} itself). This function checks whether its possible to collapse \eqn{\sigma} through \eqn{\tau}, 
(if \eqn{\tau} has \eqn{\sigma} as its only coface), and if so, both simplices are removed. 
\code{tau} and \code{sigma} are sorted before comparison.
To perform this kind of elementary collapse, call \code{collapse} with two simplices as arguments, i.e. \code{tau} before \code{sigma}.

Alternatively, this method supports another type of elementary collapse, also called a \emph{vertex collapse}, as described 
in (2). This type of collapse maps a pair of vertices into a single vertex. To use this collapse, specify three vertex ids, the first 
two representing the free pair, and the last representing the target vertex to collapse to.
}
\examples{
st <- simplextree::simplex_tree(1:3)
st \%>\% print_simplices()
# 1, 2, 3, 1 2, 1 3, 2 3, 1 2 3
st \%>\% collapse(list(1:2, 1:3))
# 1, 2, 3, 1 3, 2 3=

st \%>\% insert(list(1:3, 2:5))
st \%>\% print_simplices("column")
# 1 2 3 4 5 1 1 2 2 2 3 3 4 1 2 2 2 3 2
#           2 3 3 4 5 4 5 5 2 3 3 4 4 3
#                           3 4 5 5 5 4
#                                     5

st \%>\% collapse(list(2:4, 2:5))
st \%>\% print_simplices("column") 
# 1 2 3 4 5 1 1 2 2 2 3 3 4 1 2 2 3
#           2 3 3 4 5 4 5 5 2 3 4 4
#                           3 5 5 5
}
\references{
1. Boissonnat, Jean-Daniel, and Clement Maria. "The simplex tree: An efficient data structure for general simplicial complexes." Algorithmica 70.3 (2014): 406-427.

2. Dey, Tamal K., Fengtao Fan, and Yusu Wang. "Computing topological persistence for simplicial maps." Proceedings of the thirtieth annual symposium on Computational geometry. ACM, 2014.
}
