% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_smooth.R
\name{gg_smooth}
\alias{gg_smooth}
\title{Smoothed ggplot.}
\usage{
gg_smooth(
  data,
  x_var,
  y_var,
  pal = pal_viridis_reorder(1),
  alpha_fill = 0.2,
  alpha_line = 1,
  alpha_point = 1,
  size_line = 0.5,
  size_point = 1.5,
  title = NULL,
  title_wrap = 80,
  subtitle = NULL,
  subtitle_wrap = 80,
  x_balance = FALSE,
  x_breaks_n = 5,
  x_expand = NULL,
  x_labels = scales::label_comma(),
  x_title = NULL,
  x_title_wrap = 50,
  x_zero = FALSE,
  x_zero_line = NULL,
  y_balance = FALSE,
  y_breaks_n = 5,
  y_expand = c(0, 0),
  y_labels = scales::label_comma(),
  y_title = NULL,
  y_title_wrap = 50,
  y_zero = FALSE,
  y_zero_line = NULL,
  caption = NULL,
  caption_wrap = 80,
  theme = gg_theme(gridlines_h = TRUE, gridlines_v = TRUE),
  model_method = NULL,
  model_formula = NULL,
  model_se = TRUE,
  model_level = 0.95,
  model_span = 0.75,
  model_n = 80,
  mobile = FALSE
)
}
\arguments{
\item{data}{An ungrouped summarised tibble or dataframe in a structure for points to be plotted untransformed, and a modelled line and ribbon to plotted based on this data. Required input.}

\item{x_var}{Unquoted numeric variable to be on the x scale. Required input.}

\item{y_var}{Unquoted numeric variable to be on the y scale. Required input.}

\item{pal}{Character vector of hex codes.}

\item{alpha_fill}{The opacity of the fill. Defaults to 0.2.}

\item{alpha_line}{The opacity of the line. Defaults to 1.}

\item{alpha_point}{The opacity of the points. Defaults to 1.5.}

\item{size_line}{Size of lines. Defaults to 0.5.}

\item{size_point}{Size of points. Defaults to 1.5.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 75.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 100. Not applicable where mobile equals TRUE.}

\item{x_balance}{For a numeric x variable, add balance to the x scale so that zero is in the centre. Defaults to FALSE.}

\item{x_breaks_n}{For a numeric or date x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 5.}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_labels}{A function or named vector to modify x scale labels. Use ggplot2::waiver() to keep x labels untransformed.}

\item{x_title}{X scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{x_zero}{For a numeric x variable, TRUE or FALSE of whether the minimum of the x scale is zero. Defaults to FALSE.}

\item{x_zero_line}{For a numeric x variable, TRUE or FALSE of whether to add a zero reference line to the x scale. Defaults to TRUE if there are positive and negative values in x_var. Otherwise defaults to FALSE.}

\item{y_balance}{For a numeric y variable, add balance to the y scale so that zero is in the centre of the y scale.}

\item{y_breaks_n}{For a numeric or date x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 5.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_labels}{A function or named vector to modify y scale labels. Use ggplot2::waiver() to keep y labels untransformed.}

\item{y_title}{y scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{y_zero}{For a numeric y variable, TRUE or FALSE of whether the minimum of the y scale is zero. Defaults to TRUE.}

\item{y_zero_line}{For a numeric y variable, TRUE or FALSE whether to add a zero reference line to the y scale. Defaults to TRUE if there are positive and negative values in y_var. Otherwise defaults to FALSE.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{theme}{A ggplot2 theme.}

\item{model_method}{Smoothing algorithm to use. See ggplot2::geom_smooth for further details.}

\item{model_formula}{Formula to use in smoothing function. See ggplot2::geom_smooth for further details.}

\item{model_se}{TRUE or FALSE of whether to show confidence as a ribbon.}

\item{model_level}{The level of confidence to calculate for the ribbon.}

\item{model_span}{Controls the amount of smoothing for the default loess smoother. See ggplot2::geom_smooth for further details.}

\item{model_n}{Number of points at which to evaluate smoother.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE.}
}
\value{
A ggplot object.
}
\description{
Smoothed ggplot that is not coloured and not facetted.
}
\examples{
library(simplevis)
library(palmerpenguins)

gg_smooth(penguins, 
         x_var = bill_length_mm, 
         y_var = body_mass_g)

}
