% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_sf.R
\name{ggplot_sf_col}
\alias{ggplot_sf_col}
\title{Map of simple features in ggplot that is coloured.}
\usage{
ggplot_sf_col(data, col_var, pal = NULL, pal_rev = FALSE,
  point_size = 1, line_size = 0.5, alpha = 1, borders = NULL,
  borders_behind = TRUE, borders_pal = "#7f7f7f", borders_size = 0.2,
  title = "[Title]", title_wrap = 70, subtitle = NULL,
  subtitle_wrap = 80, col_cuts = NULL, col_labels = NULL,
  col_labels_dp = 1, col_labels_ncol = NULL, col_labels_nrow = NULL,
  col_method = NULL, col_na = TRUE, col_title = "",
  col_title_wrap = 25, caption = NULL, caption_wrap = 80,
  font_family = "Helvetica", font_size_title = NULL,
  font_size_body = NULL, isMobile = FALSE)
}
\arguments{
\item{data}{A sf object with defined coordinate reference system. Required input.}

\item{col_var}{Unquoted variable for points to be coloured by. Required input.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the colorbrewer Set1 or viridis.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{point_size}{Size of points. Defaults to 0.5.}

\item{line_size}{Size of lines. Defaults to 0.5.}

\item{alpha}{The opacity of polygons. Defaults to 0.9.}

\item{borders}{A sf object as administrative boundaries (or coastlines). Defaults to no boundaries added. The rnaturalearth package is a useful source of country and state boundaries.}

\item{borders_behind}{TRUE or FALSE  as to whether the borders is to be behind the sf object defined in the data argument. Defaults to TRUE.}

\item{borders_pal}{Colour of the borders. Defaults to "#7F7F7F".}

\item{borders_size}{Size of the borders. Defaults to 0.2.}

\item{title}{Title string. Defaults to "[Title]".}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{col_labels}{Adjust the  colour scale labels through a vector.}

\item{col_labels_dp}{Select the appropriate number of decimal places for numeric variable auto legend labels. Defaults to 1.}

\item{col_labels_ncol}{The number of columns in the legend. Defaults to 1.}

\item{col_labels_nrow}{The number of rows in the legend.}

\item{col_method}{The method of colouring features, either "bin", "quantile" or "category." NULL results in "category", if categorical or "quantile" if numeric col_var. Note all numeric variables are cut to be inclusive of the min in the range, and exclusive of the max in the range (except for the final bucket which includes the highest value).}

\item{col_na}{TRUE or FALSE of whether to show NA values of the colour variable.}

\item{col_title}{Colour title string for the legend. Defaults to NULL.}

\item{col_title_wrap}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where isMobile equals TRUE.}

\item{caption}{Caption title string. Defaults to NULL.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. If within an app with the mobileDetect function, then use isMobile = input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Map of simple features in ggplot that is coloured, but not facetted.
}
\examples{
ggplot_sf_col(data = example_sf_polygon, col_var = density, borders = nz,
     col_method = "bin", col_cuts = c(0, 10, 50, 100, 150, 200, Inf), col_labels_dp = 0,
     title = "Density, 2017")

ggplot_sf_col(data = example_sf_polygon, col_var = density, borders = nz,
     col_method = "quantile", col_cuts = c(0, 0.25, 0.5, 0.75, 0.95, 1),
     title = "Density, 2017")

 pal <- c("#4575B4", "#D3D3D3", "#D73027")

ggplot_sf_col(data = example_sf_point, col_var = trend_category, borders = nz, 
   pal = pal, col_method = "category",
   title = "Monitored trends, 2008-17")
}
