% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_hbar_fun.R
\name{ggplot_hbar_col}
\alias{ggplot_hbar_col}
\title{Horizontal bar ggplot that is coloured.}
\usage{
ggplot_hbar_col(data, x_var, y_var, col_var, tip_var = NULL,
  x_labels = waiver(), x_zero = TRUE, x_zero_line = NULL,
  x_trans = "identity", x_pretty_n = 6, x_expand = NULL,
  x_balance = FALSE, x_na_bar = FALSE, y_rev = FALSE,
  y_labels = waiver(), y_expand = NULL, col_rev = FALSE,
  position = "stack", pal = NULL, pal_rev = FALSE, legend_ncol = 3,
  width = 0.75, title = "[Title]", subtitle = NULL,
  x_title = "[X title]", y_title = "[Y title]", col_title = "",
  caption = NULL, legend_labels = NULL, font_family = "Helvetica",
  font_size_title = NULL, font_size_body = NULL, title_wrap = 70,
  subtitle_wrap = 80, x_title_wrap = 50, y_title_wrap = 50,
  wrap_col_title = 25, caption_wrap = 80, isMobile = FALSE)
}
\arguments{
\item{data}{A tibble or dataframe. Required input.}

\item{x_var}{Unquoted numeric variable to be on the x axis. Required input.}

\item{y_var}{Unquoted categorical variable to be on the y axis. Required input.}

\item{col_var}{Unquoted categorical variable to colour the bars. Required input.}

\item{tip_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot). Defaults to NULL.}

\item{x_labels}{Argument to adjust the format of the x scale labels.}

\item{x_zero}{TRUE or FALSE whether the minimum of the x scale is zero. Defaults to TRUE.}

\item{x_zero_line}{TRUE or FALSE whether to add a zero reference line to the x axis. Defaults to NULL, which is TRUE if there are positive and negative values in x_var. Otherwise it is FALSE.}

\item{x_trans}{A string specifying a transformation for the x axis scale. Defaults to "identity".}

\item{x_pretty_n}{The desired number of intervals on the x axis, as calculated by the pretty algorithm. Defaults to 6. Not applicable where isMobile equals TRUE.}

\item{x_expand}{A vector of range expansion constants used to add some padding on the x scale.}

\item{x_balance}{Add balance to the x axis so that zero is in the centre of the x scale.}

\item{x_na_bar}{TRUE or FALSE of whether to make NA x_var values infinity with a light grey colour to emphasise them. Defaults to FALSE.}

\item{y_rev}{TRUE or FALSE of whether bar order from top to bottom is reversed from default. Defaults to FALSE.}

\item{y_labels}{Argument to adjust the format of the y scale labels.}

\item{y_expand}{A vector of range expansion constants used to add some padding on the y scale.}

\item{col_rev}{TRUE or FALSE of whether bar fill order from left to right is reversed from default. Defaults to FALSE.}

\item{position}{Whether bars are positioned by "stack" or "dodge". Defaults to "stack".}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects a default palette.}

\item{pal_rev}{TRUE or FALSE of whether to reverse the pal.}

\item{legend_ncol}{The number of columns in the legend.}

\item{width}{Width of bars. Defaults to 0.75.}

\item{title}{Title string. Defaults to [Title].}

\item{subtitle}{Subtitle string. Defaults to [Subtitle].}

\item{x_title}{X axis title string. Defaults to [X title].}

\item{y_title}{Y axis title string. Defaults to [Y title].}

\item{col_title}{Colour title string for the legend. Defaults to NULL.}

\item{caption}{Caption title string. Defaults to NULL.}

\item{legend_labels}{A vector of manual legend label values. Defaults to NULL, which results in automatic labels.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_col_title}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where isMobile equals TRUE.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. If within an app with the mobileDetect function, then use isMobile = input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Horizontal bar ggplot that is coloured, but not facetted.
}
\examples{
library(dplyr)

plot_data <- ggplot2::diamonds \%>\%
  mutate(cut = stringr::str_to_sentence(cut)) \%>\%
  group_by(cut, clarity) \%>\%
  summarise(average_price = mean(price)) \%>\%
  mutate(average_price = round(average_price / 1000, 1)) \%>\%
  ungroup()

ggplot_hbar_col(plot_data, average_price, cut, clarity, 
  title = "Average diamond price by cut and clarity", 
  x_title = "Average price ($US thousands)", 
  y_title = "Cut")

}
