% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCaches.R
\name{loadCaches}
\alias{loadCaches}
\title{Loads pre-made caches}
\usage{
loadCaches(cacheNames, loadEnvir = NULL, ...)
}
\arguments{
\item{cacheNames}{Vector of caches to load.}

\item{loadEnvir}{Environment into which to load each cache.}

\item{...}{Additional parameters passed to simpleCache.}
}
\description{
This function just takes a list of caches, and loads them. It's designed
for stuff you already cached previously, so it won't build any caches.
}
\examples{
# choose location to store caches
cacheDir = tempdir()
cacheDir
setCacheDir(cacheDir)

# build some caches
simpleCache("normSample", { rnorm(5e3, 0,1) }, recreate=TRUE, timer=TRUE)
simpleCache("normSample", { rnorm(5e3, 0,1) })
simpleCache("normSample", { rnorm(5e3, 0,1) }, reload=TRUE)

# storing a cache after-the-fact
normSample2 = rnorm(10, 0, 1)
storeCache("normSample2")

# what's available?
listCaches()

# load a cache
simpleCache("normSample")

# load multiples caches
loadCaches(c("normSample", "normSample2"), reload=TRUE)
}
