% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{.tooOld}
\alias{.tooOld}
\title{Determine if a cache file is sufficiently old to warrant refresh.}
\usage{
.tooOld(pathCacheFile, lifespan = NULL)
}
\arguments{
\item{pathCacheFile}{Path to file to ask about staleness.}

\item{lifespan}{Maximum file age before it's "stale."}
}
\value{
\code{TRUE} if the file exists and its age exceeds 
        \code{lifespan} if given or 
        \code{getOption("MAX.CACHE.AGE")} if no age threshold is passed 
        and that option exists; \code{FALSE} otherwise.
}
\description{
\code{.tooOld} accepts a maximum cache age and checks for an option with 
that setting under \code{MAX.CACHE.AGE} if such an argument isn't passed.
If the indicated file exists and is older than the threshold passed or 
set as an option, the file is deemed "stale." If an age threshold is 
provided, no check for an option is performed. If the file does not 
exist or there's not an age threshold directly passed or set as an option, 
the result is \code{FALSE}.
}
