#' Print a simmr output object
#'
#' @param x An object of class \code{simmr_output}
#' @param ... Other arguments (not supported)
#'
#' @return Returns a neat summary of the object
#' 
#' @seealso \code{\link{simmr_mcmc}} for creating \code{simmr_output} objects
#' @export
print.simmr_output <-
function(x,...) {
  cat('This is a valid simmr output object with ')
  cat(paste(x$input$n_obs,'observations, '))
  cat(paste(x$input$n_tracers,'tracers, and '))
  cat(paste(x$input$n_sources,'sources.\n'))
  if(x$input$n_groups>1) cat(paste('There are',x$input$n_groups,'groups.\n'))
  cat('The source names are: ')
  cat(x$input$source_names,sep=', ')
  cat('.\n\n')
  cat('The input data has been run via simmr_mcmc and has produced ')
  cat(nrow(x$output[[1]]$BUGSoutput$sims.matrix),'iterations over',x$output[[1]]$BUGSoutput$n.chains,'MCMC chains.')
  cat('\n\n')
}
